#ifndef __FIMG2D_H
#define __FIMG2D_H

// Stuff picked from the driver header

#include <stdbool.h>

#define FIMG2D_IOCTL_MAGIC  'F'
#define FIMG2D_BITBLT_VERSION _IOR(FIMG2D_IOCTL_MAGIC, 2, struct fimg2d_version)
#define FIMG2D_BITBLT_ACTIVATE  _IOW(FIMG2D_IOCTL_MAGIC, 3, enum driver_act)
#define FIMG2D_BITBLT_BLIT  _IOWR(FIMG2D_IOCTL_MAGIC, 0, struct fimg2d_blit)

struct fimg2d_version {
  unsigned int hw;
  unsigned int sw;
};

enum driver_act {
  DRV_ACT = 0,
  DRV_DEACT
};

enum blit_op {
  BLIT_OP_SOLID_FILL = 0,

  BLIT_OP_CLR,
  BLIT_OP_SRC, BLIT_OP_SRC_COPY = BLIT_OP_SRC,
  BLIT_OP_DST,
  BLIT_OP_SRC_OVER,
  BLIT_OP_DST_OVER, BLIT_OP_OVER_REV = BLIT_OP_DST_OVER,
  BLIT_OP_SRC_IN,
  BLIT_OP_DST_IN, BLIT_OP_IN_REV = BLIT_OP_DST_IN,
  BLIT_OP_SRC_OUT,
  BLIT_OP_DST_OUT, BLIT_OP_OUT_REV = BLIT_OP_DST_OUT,
  BLIT_OP_SRC_ATOP,
  BLIT_OP_DST_ATOP, BLIT_OP_ATOP_REV = BLIT_OP_DST_ATOP,
  BLIT_OP_XOR,

  BLIT_OP_ADD,
  BLIT_OP_MULTIPLY,
  BLIT_OP_SCREEN,
  BLIT_OP_DARKEN,
  BLIT_OP_LIGHTEN,

  BLIT_OP_DISJ_SRC_OVER,
  BLIT_OP_DISJ_DST_OVER, BLIT_OP_SATURATE = BLIT_OP_DISJ_DST_OVER,
  BLIT_OP_DISJ_SRC_IN,
  BLIT_OP_DISJ_DST_IN, BLIT_OP_DISJ_IN_REV = BLIT_OP_DISJ_DST_IN,
  BLIT_OP_DISJ_SRC_OUT,
  BLIT_OP_DISJ_DST_OUT, BLIT_OP_DISJ_OUT_REV = BLIT_OP_DISJ_DST_OUT,
  BLIT_OP_DISJ_SRC_ATOP,
  BLIT_OP_DISJ_DST_ATOP, BLIT_OP_DISJ_ATOP_REV = BLIT_OP_DISJ_DST_ATOP,
  BLIT_OP_DISJ_XOR,

  BLIT_OP_CONJ_SRC_OVER,
  BLIT_OP_CONJ_DST_OVER, BLIT_OP_CONJ_OVER_REV = BLIT_OP_CONJ_DST_OVER,
  BLIT_OP_CONJ_SRC_IN,
  BLIT_OP_CONJ_DST_IN, BLIT_OP_CONJ_IN_REV = BLIT_OP_CONJ_DST_IN,
  BLIT_OP_CONJ_SRC_OUT,
  BLIT_OP_CONJ_DST_OUT, BLIT_OP_CONJ_OUT_REV = BLIT_OP_CONJ_DST_OUT,
  BLIT_OP_CONJ_SRC_ATOP,
  BLIT_OP_CONJ_DST_ATOP, BLIT_OP_CONJ_ATOP_REV = BLIT_OP_CONJ_DST_ATOP,
  BLIT_OP_CONJ_XOR,

  /* user select coefficient manually */
  BLIT_OP_USER_COEFF,

  BLIT_OP_USER_SRC_GA,

  /* Add new operation type here */

  /* end of blit operation */
  BLIT_OP_END,
};

enum rotation {
  ORIGIN,
  ROT_90, /* clockwise */
  ROT_180,
  ROT_270,
  XFLIP,  /* x-axis flip */
  YFLIP,  /* y-axis flip */
};

enum premultiplied {
  PREMULTIPLIED,
  NON_PREMULTIPLIED,
};

enum scaling {
  NO_SCALING,
  SCALING_NEAREST,
  SCALING_BILINEAR,
};

struct fimg2d_scale {
  enum scaling mode;

  /* ratio in pixels */
  int src_w, src_h;
  int dst_w, dst_h;
};

enum repeat {
  NO_REPEAT = 0,
  REPEAT_NORMAL,  /* default setting */
  REPEAT_PAD,
  REPEAT_REFLECT, REPEAT_MIRROR = REPEAT_REFLECT,
  REPEAT_CLAMP,
};

struct fimg2d_repeat {
  enum repeat mode;
  unsigned long pad_color;
};

enum bluescreen {
  OPAQUE,
  TRANSP,
  BLUSCR,
};

struct fimg2d_bluscr {
  enum bluescreen mode;
  unsigned long bs_color;
  unsigned long bg_color;
};

struct fimg2d_clip {
  bool enable;
  int x1;
  int y1;
  int x2; /* x1 + width */
  int y2; /* y1 + height */
};

struct fimg2d_param {
  unsigned long solid_color;
  unsigned char g_alpha;
  bool dither;
  enum rotation rotate;
  enum premultiplied premult;
  struct fimg2d_scale scaling;
  struct fimg2d_repeat repeat;
  struct fimg2d_bluscr bluscr;
  struct fimg2d_clip clipping;
};

enum pixel_order {
  AX_RGB = 0,
  RGB_AX,
  AX_BGR,
  BGR_AX,
  ARGB_ORDER_END,

  P1_CRY1CBY0,
  P1_CBY1CRY0,
  P1_Y1CRY0CB,
  P1_Y1CBY0CR,
  P1_ORDER_END,

  P2_CRCB,
  P2_CBCR,
  P2_ORDER_END,
};

enum color_format {
  CF_XRGB_8888 = 0,
  CF_ARGB_8888,
  CF_RGB_565,
  CF_XRGB_1555,
  CF_ARGB_1555,
  CF_XRGB_4444,
  CF_ARGB_4444,
  CF_RGB_888,
  CF_YCBCR_444,
  CF_YCBCR_422,
  CF_YCBCR_420,
  CF_A8,
  CF_L8,
  SRC_DST_FORMAT_END,

  CF_MSK_1BIT,
  CF_MSK_4BIT,
  CF_MSK_8BIT,
  CF_MSK_16BIT_565,
  CF_MSK_16BIT_1555,
  CF_MSK_16BIT_4444,
  CF_MSK_32BIT_8888,
  MSK_FORMAT_END,
};

enum addr_space {
  ADDR_NONE,
  ADDR_PHYS,
  ADDR_KERN,
  ADDR_USER,
  ADDR_USER_CONTIG,
  ADDR_DEVICE,
};

struct fimg2d_addr {
  enum addr_space type;
  unsigned long start;
};

struct fimg2d_rect {
  int x1;
  int y1;
  int x2; /* x1 + width */
  int y2; /* y1 + height */
};

struct fimg2d_image {
  int width;
  int height;
  int stride;
  enum pixel_order order;
  enum color_format fmt;
  struct fimg2d_addr addr;
  struct fimg2d_addr plane2;
  struct fimg2d_rect rect;
  bool need_cacheopr;
};

enum blit_sync {
  BLIT_SYNC,
  BLIT_ASYNC,
};

enum fimg2d_qos_level {
  G2D_LV0 = 0,
  G2D_LV1,
  G2D_LV2,
  G2D_LV3,
  G2D_LV4,
  G2D_LV_END
};

struct fimg2d_blit {
  enum blit_op op;
  struct fimg2d_param param;
  struct fimg2d_image *src;
  struct fimg2d_image *msk;
  struct fimg2d_image *tmp;
  struct fimg2d_image *dst;
  enum blit_sync sync;
  unsigned int seq_no;
  enum fimg2d_qos_level qos_lv;
};

#endif 