#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include  <CommonCrypto/CommonCryptor.h>
#include <string.h>
#include <CoreFoundation/CoreFoundation.h>
#include "sandbox.h"
#include <pthread.h>
#include <sys/types.h>
#include <atomic>
#include <sys/socket.h>
#include <queue>
#define DYLD_INTERPOSE(_replacment,_replacee) \
__attribute__((used)) static struct{ const void* replacment; const void* replacee; } _interpose_##_replacee \
__attribute__ ((section ("__DATA,__interpose"))) = { (const void*)(unsigned long)&_replacment, (const void*)(unsigned long)&_replacee };

struct cryptoargs {
    CCOperation     op;
    CCMode            mode;
    CCAlgorithm        alg;
    CCPadding        padding;
    void         *iv = 0;            /* optional initialization vector */
    void         *key;            /* raw key material */
    size_t             keyLength;
    const void         *tweak;            /* raw tweak material */
    size_t             tweakLength;
    int                numRounds;        /* 0 == default */
    CCModeOptions     options;
};

int delay = 100;
std::queue<cryptoargs> vidargs;
std::queue<cryptoargs> audargs;
CCCryptorRef    vidRef;



CCCryptorStatus mycryptor(
	CCCryptorRef cryptorRef,
	const void *dataIn,
	size_t dataInLength,
	void *dataOut,				
	size_t dataOutAvailable,
	size_t *dataOutMoved);

DYLD_INTERPOSE(mycryptor, CCCryptorUpdate);


int msgloop = 14041;
int seq = 0;
int hseq = 0;
int seq1 = 0;
int hseq1 = 0;
int sinit = 0;
int vinit = 0;
int ainit1 = 0;
int ainit2 = 0;
char vidssrc[4];
char assrc1[4];
char assrc2[4];
char vidseq[2];
char aseq1[2];
char aseq2[2];


static std::atomic_flag spinlock2 = ATOMIC_FLAG_INIT;

ssize_t mysendmsg(int sockfd, const struct msghdr *msg, int flags){
  char name2[1024];
    pthread_t         self;
    self = pthread_self();
    pthread_getname_np(self, name2, 1024);

    if(strcmp(name2,  "com.apple.avconference.mediaqueue.sendproc") == 0){
        while (atomic_flag_test_and_set_explicit(&spinlock2,
                                                 std::memory_order_acquire)) {}
        delay++;
        if(delay > 100){
            
            
        bool audio = false;
        char name[1024];
        if(msg->msg_iovlen > 1){
            char* pack = (char*) msg->msg_iov[1].iov_base;

            if(!sinit){
                char payload = pack[1];
                payload = payload & 0x7f;
                if ( payload == '\x7b'){
                if(!vinit){
                    memcpy(&vidssrc, pack + 8, 4);
                    memcpy(&vidseq, pack + 2, 2);
                    vinit = 1;
                    }
                } else if ( payload == '\x68'){
                    if(!ainit1){
                        memcpy(&assrc1, pack + 8, 4);
                        memcpy(&aseq1, pack + 2, 2);
                        ainit1 = 1;
                    }
                } else if ( payload == '\x77'){
                    if(!ainit2){
                        memcpy(&assrc2, pack + 8, 4);
                        memcpy(&aseq2, pack + 2, 2);
                        ainit2 = 1;
                    }
                }else{
                    abort();
                }

                if(vinit==1 && ainit1 == 1 && ainit2 == 1){
                        
                    sinit = 1;
                }
                    
            }
                    
            sprintf(name, "/out/extra_%d", msgloop);

            FILE* f = 0;
            f = fopen(name, "rb");
            size_t size = 0;
            char* mes = 0;
            fseek(f, 0L, SEEK_END);
            size = ftell(f);
            rewind(f);
            mes = (char*)malloc(size);
            fread(mes, size, 1, f);
            fclose(f);

           char* m = (char*) malloc(size);

            m[0] = mes[0];
            m[1] = mes[1];
            m[4] = mes[4]; //keep timestamp
            m[5] = mes[5];
            m[6] = mes[6];
            m[7] = mes[7];
                

            char payload = mes[1] & 0x7f;
                
            if( payload == 0x7b){
                
                if ( seq == 0){
                    
                    ((char*)&seq)[0] = pack[3];
                    ((char*)&seq)[1] = pack[2];
                    
                }
                if ( hseq == 0){
                    
                    ((char*)&hseq)[0] = mes[3];
                    ((char*)&hseq)[1] = mes[2];
                    
                }
                
                int cseq = 0;
                
                ((char*)&cseq)[0] = mes[3];
                ((char*)&cseq)[1] = mes[2];
                int nseq = seq + (cseq - hseq);
                m[3] = nseq & 0xff;
                m[2] = (nseq & 0xff00) >> 8;
                memcpy(m+8, &vidssrc, 4);
            }else{
                    
                if ( seq1 == 0){
                        
                    ((char*)&seq1)[0] = pack[3];
                    ((char*)&seq1)[1] = pack[2];
                        
                }
                if ( hseq1 == 0){
                        
                    ((char*)&hseq1)[0] = mes[3];
                    ((char*)&hseq1)[1] = mes[2];
                        
                }
                    
                int cseq = 0;
                    
                ((char*)&cseq)[0] = mes[3];
                ((char*)&cseq)[1] = mes[2];
                int nseq = seq + (cseq - hseq);
                m[3] = nseq & 0xff;
                m[2] = (nseq & 0xff00) >> 8;
                    
                if((payload == 0x68)&&ainit1){
                    memcpy(m+8, &assrc1, 4);
                }else if(ainit2){
                    memcpy(m+8, &assrc2, 4);
                        
                }
                    
            }
                    
            memcpy(m+12, mes+12, size - 12);
            int elen = 0;
            ((char*)&elen)[0] = m[15];
            ((char*)&elen)[1] = m[14];
            int offset = 12;
            char h = m[0];
            if(h & 0x10){
                int extlen = m[15];
                offset = offset + 4 + extlen*4;
            }
            size_t o;
            payload = m[1] & 0x7f;

            msg->msg_iov[1].iov_base = m;
            msg->msg_iov[1].iov_len  = size;
            fclose(f);

            ((char*)msg->msg_iov[0].iov_base)[2] = (((size) & 0xff00) >> 8);
            ((char*)msg->msg_iov[0].iov_base)[3] = (size) & 0xff; //correct the STUN size
        }

        msgloop++;
        }
        atomic_flag_clear_explicit(&spinlock2, std::memory_order_release);
    return sendmsg(sockfd, msg, flags);
        
    }
    
    return sendmsg(sockfd, msg, flags);


}

bool vidset = false;
bool audset = false;
DYLD_INTERPOSE(mysendmsg, sendmsg);


int loop = 0;



static std::atomic_flag spinlock = ATOMIC_FLAG_INIT;
CCCryptorStatus mycryptor(
	CCCryptorRef cryptorRef,
	const void *dataIn,
	size_t dataInLength,
	void *dataOut,				
	size_t dataOutAvailable,
	size_t *dataOutMoved) {

    while (atomic_flag_test_and_set_explicit(&spinlock,
                                             std::memory_order_acquire)) {
    }
    char* m = 0;
    dispatch_queue_t queue = dispatch_get_current_queue();
    const char * name =  dispatch_queue_get_label(queue);
    FILE* hFile;
    char name2[1024];
    pthread_t         self;
    self = pthread_self();
    pthread_getname_np(self, name2, 1024);
    int vid = 0;
    char* dataInCopy = 0;
    if ((strcmp(name,  "com.apple.VideoConference.videoTransmit") == 0)||(strcmp(name2,  "com.apple.avconference.packetThread.com.apple.AVConference.auio") == 0)){

    vid = 1;
  

       *((unsigned int *)((char*)dataIn + 0x650)) = (unsigned int) dataInLength;
    }

    CCCryptorStatus s;
    if(vid){
        
        s = CCCryptorUpdate(cryptorRef, dataIn, dataInLength, dataOut, dataOutAvailable, dataOutMoved);




    }else{
    s = CCCryptorUpdate(cryptorRef, dataIn, dataInLength, dataOut, dataOutAvailable, dataOutMoved);

    }
   atomic_flag_clear_explicit(&spinlock, std::memory_order_release);
    return s;
    
}



