﻿using System;
using System.Runtime.InteropServices;

namespace StorageResearch
{
    enum EDataFlow
    {
        eRender = 0,
        eCapture = (eRender + 1),
        eAll = (eCapture + 1),
        EDataFlow_enum_count = (eAll + 1)
    }

    enum ERole
    {
        eConsole = 0,
        eMultimedia = (eConsole + 1),
        eCommunications = (eMultimedia + 1),
        ERole_enum_count = (eCommunications + 1)
    }

    [ComImport, Guid("BCDE0395-E52F-467C-8E3D-C4579291692E")]
    class MMDeviceEnumerator
    {
    }

    [ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown), Guid("D666063F-1587-4E43-81F1-B948E807363F")]
    interface IMMDevice
    {
        [return: MarshalAs(UnmanagedType.Interface)]
        object Activate(
            ref Guid iid,
            uint dwClsCtx,
            IntPtr pActivationParams);
        
        //virtual /* [helpstring][id] */ HRESULT STDMETHODCALLTYPE OpenPropertyStore(
        //    /* [annotation][in] */
        //    _In_ DWORD stgmAccess,
        //    /* [annotation][out] */
        //    _Out_ IPropertyStore **ppProperties) = 0;
        
        //virtual /* [helpstring][id] */ HRESULT STDMETHODCALLTYPE GetId(
        //    /* [annotation][out] */
        //    _Outptr_ LPWSTR *ppstrId) = 0;
        
        //virtual /* [helpstring][id] */ HRESULT STDMETHODCALLTYPE GetState(
        //    /* [annotation][out] */
        //    _Out_ DWORD *pdwState) = 0;
    }

    [ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    [Guid("0BD7A1BE-7A1A-44DB-8397-CC5392387B5E")]
    interface IMMDeviceCollection
    {
        uint GetCount();
        [return: MarshalAs(UnmanagedType.Interface)]
        IMMDevice Item(uint nDevice);
    }

    [ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    [Guid("A95664D2-9614-4F35-A746-DE8DB63617E6")]
    interface IMMDeviceEnumerator
    {
        [return: MarshalAs(UnmanagedType.Interface)]
        IMMDeviceCollection EnumAudioEndpoints(
            EDataFlow dataFlow,
            uint dwStateMask);
        
        [return: MarshalAs(UnmanagedType.Interface)]
        IMMDevice GetDefaultAudioEndpoint(
            EDataFlow dataFlow,
            /* [annotation][in] */
            ERole role);

        //[return: MarshalAs(UnmanagedType.IUnknown)]
        //IMMDevice GetDevice(
        //    [MarshalAs(UnmanagedType.LPWStr)] string pwstrId);

        //void RegisterEndpointNotificationCallback(
        //    IMMNotificationClient pClient);

        //void UnregisterEndpointNotificationCallback(
        //    IMMNotificationClient pClient);
    }

    enum AUDCLNT_SHAREMODE
    {
        AUDCLNT_SHAREMODE_SHARED,
        AUDCLNT_SHAREMODE_EXCLUSIVE
    }

    [ComImport, InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
    [Guid("1CB9AD4C-DBFA-4c32-B178-C2F568A703B2")]
    interface IAudioClient
    {
        void Initialize(
            /* [annotation][in] */
            AUDCLNT_SHAREMODE ShareMode,
            /* [annotation][in] */
            uint StreamFlags,
            /* [annotation][in] */
            long hnsBufferDuration,
            /* [annotation][in] */
            long hnsPeriodicity,
            /* [annotation][in] */
            IntPtr pFormat,
            /* [annotation][in] */
            IntPtr AudioSessionGuid);

        uint GetBufferSize();

        long GetStreamLatency();
        
        uint GetCurrentPadding();

        void IsFormatSupported();
        //    /* [annotation][in] */
        //    _In_ AUDCLNT_SHAREMODE ShareMode,
        //    /* [annotation][in] */
        //    _In_  const WAVEFORMATEX* pFormat,
        //    /* [unique][annotation][out] */
        //    _Out_opt_ WAVEFORMATEX **ppClosestMatch) = 0;

        IntPtr GetMixFormat();
        
        //virtual HRESULT STDMETHODCALLTYPE GetDevicePeriod(
        //    /* [annotation][out] */
        //    _Out_opt_ REFERENCE_TIME *phnsDefaultDevicePeriod,
        //    /* [annotation][out] */
        //    _Out_opt_ REFERENCE_TIME *phnsMinimumDevicePeriod) = 0;
        
        //virtual HRESULT STDMETHODCALLTYPE Start(void) = 0;
        
        //virtual HRESULT STDMETHODCALLTYPE Stop(void) = 0;
        
        //virtual HRESULT STDMETHODCALLTYPE Reset(void) = 0;
        
        //virtual HRESULT STDMETHODCALLTYPE SetEventHandle(
        //    /* [in] */ HANDLE eventHandle) = 0;
        
        //virtual HRESULT STDMETHODCALLTYPE GetService(
        //    /* [annotation][in] */
        //    _In_ REFIID riid,
        //    /* [annotation][iid_is][out] */
        //    _Out_  void** ppv) = 0;
    }
}
