# LifeSize Room 5.0.9, remote config disclosure, code execution & local privilege escalation

Ultimately the Lifesize Room products have fundamentally flawed firmware, many similar very bugs in the WebUI exist and thier support team have been recommending that port 443 isn't accessible via the internet.

They've been alerted to several very similar bugs, and in some cases have fixed one gaping security hole only to leave another one literally 10 lines above completely untouched. *facepalm*

What makes this different? This exploit will run your payload as `root`.

## Description

This exploit uses the `LsSystemRestore.sh` script to disclose the current
configuration, that is then leveraged to gain access to exploitable APIs in
the admin portal which allow arbitrary command injection, then uses a local
privilege escalation bug to execute the payload as root.
 
This will work as long as port 443 is open on the phone, Lifesize support
should recommend that the power and ethernet cables are disconnected from the
device to ensure it remains secure.
 
`LsSystemRestore.sh` allows `autosh` commands to be executed without any
authentication, this is used to grab the Admin password via the `get config -P`
command.
 
Using the Admin password AMF commands can be sent to the `LSRoom_Remoting`
endpoint, this contains a method called `doPrefCommand` which is vulnerable to
command injection.

```php
function doPrefCommand($cmd, $id){
		
		// Look for the existence of a "pref " and ";" needle.
		$invalidCmd = $this->scrubPrefString($cmd);
		
		if ( $invalidCmd )
		{
			return "invalid_command";
		}
		
		// If we get to here, we want to double check the command for
		// any unwanted characters:  #&;`|*?~<>^()[]{}$\, \x0A and \xFF. ' and "
		//$cleanCommand = escapeshellcmd($cmd);
				
		$prefData = array();
		$value = rtrim(shell_exec($cmd));
```

What's interesting here is that the `escapeshellcmd` function is commented out, this would have prevented the command injection, but all of the code on the firmware smells of barely competent development and least-effort attempts to patch security vulnerabilities.
 
Local privilege escalation to root is gained by executing the setuid
`tcpdump_manager` executable, which runs a program called `reset_tcpdump` using `PATH`
to resolve its location using `PATH=/tmp:$PATH tcpdump_manager`

Other exploits exist in the 'support' portal, providing command execution, for example in `support/download_file.php`:

```php
<html>
<head>
<?php
print('
</head>
<body>
<h1>Download File </h1>
');

$file_to_download=$_REQUEST['file_to_download'];
{
	print("<hr>\n");
	shell_exec("rm tmp/tmp-file.tmp");
        shell_exec("cp $file_to_download tmp/tmp-file.tmp");
```

## Usage

```
$ deathsize.php 192.168.40.39 payload
[*] Retrieving admin password
[*] Saving config for 192.168.40.39
[*] Admin password is: 1234
[*] Authenticating for AMF RPC
[*] Sending command: ...
...
```

This will save the configuration for the device into the local file `192.168.40.39.config` and then execute the code in your payload file as `root` on the device and print out the response.

## Timeline

 * 13th June 2016 - Notified LifeSize of multiple vulnerabilities
 * 15th June - LifeSize start spamming my inbox with marketing messages
 * 16th June - Requested escallation, support requested demo
 * 22nd June - Telling LifeSize that no... just changing the password doesn't fix it
 * 30th June - Test device provided by support
 * 1st July - Owned their test device running latest firmware
 * 4th July - Support can't reproduce or understand exploit
 * 5th July - Engineering ticket created
 * 7th July - Support recommend adding firewall, *sigh*
 * 8th August - Provide PoC

Have had no further contact with them, unable to get a CVE assigned for this, product will be EOL in January 2017, seems like there's no firmware update coming...