/*

by Luigi Auriemma

UNIX & WIN VERSION
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "md5.h"

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif





#define VER     "0.1"
#define BUFFSZ  2048
#define COMM    4
#define TIMEOUT 5
#define CSZ     128




void gamespyxor(u_char *string, int len);
void timeout(int sock);
u_long resolv(char *host);
void std_err(void);




u_char command[COMM][CSZ] = {
    "\\uok\\\\cd\\%s\\skey\\%d\\errmsg\\Valid CD Key",
    "\\unok\\\\cd\\%s\\skey\\%d\\errmsg\\Invalid CD Key",
    "\\ison\\skey\\%d\\cd\\%s",
    "\\ucount\\"
};


/*
other commands, but sent to the master server:
  \disc\\pid\%d\cd\%s\ip\%d
  \auth\\pid\%d\ch\%s\resp\%s\ip\%d\skey\%d

errmsg can be what we want as also "CD Key in use"
*/





int main(int argc, char *argv[]) {
    int         sd,
                err,
                slen = 0,
                psz;
    u_short     port;
    u_char      *buff,
                sendbuff[CSZ + 1],
                keyhash[33],
                md5h[16],
                comm,
                i,
                x;
    const char  *hex = "0123456789abcdef";
    struct  sockaddr_in peer;
    md5_state_t md5t;


    setbuf(stdout, NULL);

    fputs("\n"
        "GsHinfo "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 5) {
        printf("\nUsage: %s <server> <port> <command_num> <cd-key*>\n"
            "\n"
            "Command number:\n"
            "1 = uok:    says to the server that the cd-key is valid (can't work because\n"
            "            it is an answer from the master server not a real command or query,\n"
            "            so use only the commands 3 and 4)\n"
            "2 = unok:   says to the server that the cd-key is not valid (as above)\n"
            "3 = ison:   to know if a specific cd-key is used in the server (works only if\n"
            "            the ucount reply is major than 0)\n"
            "4 = ucount: to know the number of people in the server that have a valid cd-key\n"
            "            this command doesn't need a cd-key so you can use what you want\n"
            "   other commands are \"auth\" and \"disc\"\n"
            "\n"
            "Known games and default query ports:\n"
            "  Battlefield 1942               23000, 22000 (LAN)\n"
            "  Contract Jack                  27888\n"
            "  Gore                           27778\n"
            "  Halo                           2302\n"
            "  Hidden & Dangerous 2           11004\n"
            "  IGI 2: Covert Strike           26001\n"
            "  Judge Dredd: Dredd vs. Death   25858\n"
            "  Need For Speed Hot Pursuit 2   61220\n"
            "  TRON2.0                        27888\n"
            "  others...\n"
            "\n"
            "* cd-key: you can use a cd-key or directly the MD5 hash of a cd-key\n"
            "\n", argv[0]);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    srand(time(NULL));      // randomization, used only for skey

    comm = (argv[3][0] - 1) & 3;

    err = strlen(argv[4]);
    if(err != 32) {
        md5_init(&md5t);
        md5_append(&md5t, argv[4], err);
        md5_finish(&md5t, md5h);
        for(i = 0, x = 0; i < 16; i++) {
            keyhash[x++] = hex[md5h[i] >> 4];
            keyhash[x++] = hex[md5h[i] & 0xf];
        }
        keyhash[x] = 0x00;
        printf("Cd-key %s has MD5 hash %s\n", argv[4], keyhash);
    } else {
        strcpy(keyhash, argv[4]);
        printf("You have choosen to use the cd-key MD5 hash %s\n", keyhash);
    }

    port                 = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    psz                  = sizeof(peer);

    printf("Contacting %s:%hu\n",
        inet_ntoa(peer.sin_addr), port);

    switch(comm) {
        case 0:
        case 1: slen = sprintf(sendbuff, command[comm], keyhash, rand()); break;
        case 2: slen = sprintf(sendbuff, command[comm], rand(), keyhash); break;
        case 3: {
            slen = strlen(command[comm]);
            memcpy(sendbuff, command[comm], slen);
            } break;
    }

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("\nSending:\n%s\n\n", sendbuff);
    gamespyxor(sendbuff, slen);
    err = sendto(sd, sendbuff, slen, 0, (struct sockaddr *)&peer, psz);
    if(err < 0) std_err();

    if(comm > 1) {
        fputs("\t...waiting answer\n", stdout);
        timeout(sd);

        buff = malloc(BUFFSZ);
        if(!buff) std_err();

        err = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
        if(err < 0) std_err();
        buff[err] = 0x00;
        if(*buff == ';') {
            gamespyxor(buff, err);
        } else {
            fputs("\nServer doesn't support hidden queries, but the following is the plain-text reply:\n", stdout);
        }
        printf("\n%s\n\n", buff);
    }

    close(sd);
    return(0);
}






void gamespyxor(u_char *string, int len) {
    u_char  gamespy[] = "gamespy",
            *gs;
    for(gs = gamespy; len; len--, gs++, string++) {
        if(!*gs) gs = gamespy;
        *string ^= *gs;
    }
}





void timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) {
        fputs("\nError: socket timeout\n", stdout);
        exit(1);
    }
}





u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}





#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



