#!/usr/bin/python2
# -*- coding: utf-8 -*-

import pwnlib

def find_symbol(elf, symbol_name):
    return elf.symbols[symbol_name]

def find_arm_gadget(elf, gadget, validate = False):
    gadget_bytes = pwnlib.asm.asm(gadget, arch='arm')
    gadget_address = None
    for address in elf.search(gadget_bytes):
        if address % 4 == 0:
            gadget_address = address
            if validate:
                if gadget_bytes == elf.read(gadget_address, len(gadget_bytes)):
                    print pwnlib.asm.disasm(gadget_bytes, vma=gadget_address, arch='arm')

                break

    return gadget_address

def find_thumb_gadget(elf, gadget, validate = False):
    gadget_bytes = pwnlib.asm.asm(gadget, arch='thumb')
    gadget_address = None
    for address in elf.search(gadget_bytes):
        if address % 2 == 0:
            gadget_address = address + 1
            if validate:
                if gadget_bytes == elf.read(gadget_address - 1, len(gadget_bytes)):
                    print pwnlib.asm.disasm(gadget_bytes, vma=gadget_address-1, arch='thumb')

                break

    return gadget_address

def find_gadget(elf, gadget):
    gadget_address = find_thumb_gadget(elf, gadget)
    if gadget_address is not None:
        return gadget_address

    return find_arm_gadget(elf, gadget)

def find_rop_gadgets(module_path, required_gadgets, module_base = None):
    elf = pwnlib.elf.ELF(module_path)

    if module_base:
        elf.address = module_base

    result_gadgets = { }
    for gadget_name, gadget in required_gadgets.iteritems():
        if not isinstance(gadget, tuple):
            raise Exception('Expecting dictionary of tuples - %s is %s' % (gadget_name, type(gadget)))

        func, params = gadget[0], gadget[1:]
        result = func(elf, *params)
        result_gadgets[gadget_name] = result
        if DEBUG:
            if result:
                output = '0x%08x (0x%08x + 0x%x)' % (result, module_base, result - module_base)
            else:
                output = '<??>'

            print '\t%s(%s): %s' % (func.func_name, gadget_name, output)

    return result_gadgets
