#include "common.h"

void eventfd_dec(int fd) {
  uint64_t num;
  if (read(fd, &num, 8) != 8) err(1, "eventfd read");
}

void eventfd_inc(int fd) {
  uint64_t num = 1;
  if (write(fd, &num, 8) != 8) err(1, "eventfd write");
}

static void eventfd_alloc(int tfd) {
  int fd = eventfd(0, EFD_SEMAPHORE);
  if (fd == -1) err(1, "eventfd");
  if (dup2(fd, tfd) != tfd) err(1, "dup2");
  close(fd);
}

static pid_t xfork(int (*child_main)(void)) {
  pid_t child = fork();
  if (child == -1) err(1, "fork");
  if (child == 0) exit(child_main());
  return child;
}

int main(void) {
  setbuf(stdout, NULL);

  eventfd_alloc(SYNC_EFD_A);
  eventfd_alloc(SYNC_EFD_B);
  eventfd_alloc(SYNC_EFD_D);

  xfork(reload_timer_main);
  xfork(thread_spawner_main);

  eventfd_dec(SYNC_EFD_A);
  eventfd_dec(SYNC_EFD_A);

  xfork(register_main);

  for (int i=0; i<3; i++) {
    int status;
    pid_t pid = wait(&status);
    printf("pid %d quit: ", pid);
    if (WIFEXITED(status)) {
      printf("exit(%d)", WEXITSTATUS(status));
    } else if (WIFSIGNALED(status)) {
      printf("signal(%d)", WTERMSIG(status));
    } else {
      printf("???");
    }
    printf("\n");
  }
  return 0;
}