#pragma once
class ScopedHandle
{
	HANDLE g_h;

public:
	ScopedHandle(HANDLE h, bool duplicate);
    ScopedHandle(HANDLE h) : ScopedHandle(h, false) {}
	void Close();
	void Reset(HANDLE h);
	bool IsValid() const {
		return (g_h != nullptr) && (g_h != INVALID_HANDLE_VALUE);
	}
	ScopedHandle(const ScopedHandle& other);
	ScopedHandle& operator=(const ScopedHandle& other);

	ScopedHandle(ScopedHandle&& other) noexcept;
	ScopedHandle& operator=(ScopedHandle&& other) noexcept;

	operator HANDLE() const {
		return g_h;
	}	

	~ScopedHandle();
};

