#ifndef __FAIMTEST_H__
#define __FAIMTEST_H__

#include <aim.h> 
#include <assert.h>

#define ERROR -1

extern aim_session_t g_session;

/* This is kept in the aim_session_t and accessible by handlers. */
struct w00aimexp_priv
{
	char *aimbinarypath;
	char *screenname, *password;
	char *server;
	int connected;
};

/* login.c */
int login(aim_session_t *sess, const char *sn, const char *passwd);
int logout(aim_session_t *sess);

/* w00aimexp.c */
int w00aimexp_parse_connerr(aim_session_t *sess, aim_frame_t *fr, ...);
int w00aimexp_handleredirect(aim_session_t *sess, aim_frame_t *fr, ...);
int w00aimexp_serverready(aim_session_t *sess, aim_frame_t *fr, ...);
int w00aimexp_conncomplete(aim_session_t *sess, aim_frame_t *fr, ...);
void addcb_bos(aim_session_t *sess, aim_conn_t *bosconn);

#define DPRINTF_OUTSTREAM stdout

#ifdef DEBUG

#define dprintf(x) { \
  fprintf(DPRINTF_OUTSTREAM, "[w00aimexp] " x); \
  fflush(DPRINTF_OUTSTREAM); \
}

#define dvprintf(x, y...) { \
  fprintf(DPRINTF_OUTSTREAM, "[w00aimexp] " x, y); \
  fflush(DPRINTF_OUTSTREAM); \
}

#define dinlineprintf(x) { \
  fprintf(DPRINTF_OUTSTREAM, x); \
  fflush(DPRINTF_OUTSTREAM); \
}

#define dvinlineprintf(x, y...) { \
  fprintf(DPRINTF_OUTSTREAM, x, y); \
  fflush(DPRINTF_OUTSTREAM); \
}

#else // !DEBUG

#define dprintf(x) ;
#define dvprintf(x, y...) ;
#define dinlineprintf(x) ;
#define dvinlineprintf(x, y...) ;

#endif

#define dperror(x) dvprintf("%s: %s\n", x, strerror(errno));


#endif /* __FAIMTEST_H__ */
