#define VERSION         "0.31"
#define TCPHDR          sizeof(struct tcphdr)
#define PSEUHDR         sizeof(struct pseudohdr)
#define IP              struct iphdr
#define TCP             struct tcphdr
#define ifc_buf         ifc_ifcu.ifcu_buf
#define ifc_req         ifc_ifcu.ifcu_req
#define ifr_name        ifr_ifrn.ifrn_name
#define IFHWADDRLEN      6
#define IFNAMSIZ         16



struct ifmap
{
  unsigned long mem_start;
  unsigned long mem_end;
  unsigned short base_addr;
  unsigned char irq;
  unsigned char dma;
  unsigned char port;
};

struct ifreq
{
  union
  {
    char ifrn_name[IFNAMSIZ];
  } ifr_ifrn;
  union
  {
    struct sockaddr ifru_addr;
    struct sockaddr ifru_dstaddr;
    struct sockaddr ifru_broadaddr;
    struct sockaddr ifru_netmask;
    struct sockaddr ifru_hwaddr;
    short  ifru_flags;
    int    ifru_metric;
    int    ifru_mtu;
    struct ifmap ifru_map;
    char ifru_slave[IFNAMSIZ];
    caddr_t ifru_data;
  } ifr_ifru;
};

struct ifconf
{
  int ifc_len;
  union
    {
      caddr_t ifcu_buf;
      struct ifreq * ifcu_req;
    } ifc_ifcu;
};

struct pseudohdr {
unsigned long saddr;
unsigned long daddr;
unsigned char useless;
unsigned char protocol;
unsigned short length;
};

struct replylist {
unsigned long ip;
struct replylist *next;
};

typedef struct _tcpinfo {
unsigned short srcPort;
unsigned short dstPort;
unsigned char flags;
unsigned long seq;
unsigned long ack;
unsigned long optionsLength;
unsigned char *options;
unsigned long payloadLength;
unsigned char *payload;
unsigned char payloadNeedFree;
} TCPINFO;



unsigned short in_cksum(unsigned short *addr, int len);
unsigned short ipChecksum(unsigned short *ptr, int nbytes);
