/*-
 * Copyright (c) 2002, Mike Benham
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of this program nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <linux/netfilter_ipv4.h>

#include "network.h"

#define MIN_LOCAL_PORT 9001

int NETWORK_listenOnPort(int port) {
  struct sockaddr_in server;
  
  int opt                = 1;
  int fd                 = socket(AF_INET, SOCK_STREAM, 0);
  server.sin_family      = AF_INET;
  server.sin_addr.s_addr = htonl(INADDR_ANY);
  server.sin_port        = htons(port);

  if (setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt)) < 0) {
    perror("ASSERT - setsockopt() failed.");
    exit(1);
  }
  
  if (bind(fd, (struct sockaddr*)&server, sizeof(server)) < 0) {
    return -1;
  }

  if (listen(fd, 20) < 0) {
    perror("ASSERT - listen() failed.");
    exit(1);
  }
  
  return fd;
}


int NETWORK_connectToServer(int client) {
  struct sockaddr_in localAddr;
  struct sockaddr_in serverAddr;
  int fd, size;

  size = sizeof(serverAddr);
  if (getsockopt(client, SOL_IP, SO_ORIGINAL_DST, &serverAddr, &size) < 0) {
    perror("Could not determine socket's original destination.");
    close(client);
    exit(1);
  }
  
  fd = socket(AF_INET, SOCK_STREAM, 0);

  while (1) { /* Find an unused port > MIN_LOCAL_PORT */
    localAddr.sin_family      = AF_INET;
    localAddr.sin_addr.s_addr = htonl(INADDR_ANY);
    localAddr.sin_port        = htons((rand() % 1000) + MIN_LOCAL_PORT);
    
    if (bind(fd, (struct sockaddr*)&localAddr, sizeof(localAddr)) >= 0) {
      break;
    }
  }

  if (connect(fd, (struct sockaddr*)&serverAddr, sizeof(serverAddr)) < 0) {
    /* What does one do without exceptions? */
    perror("Connect to original destination failed.");
    close(client);
    exit(1);
  }

  return fd;
}


int NETWORK_acceptConnection(int serverSocket) {
  struct sockaddr_in addr;
  int fd;

  int length = sizeof(addr);

  if ((fd = accept(serverSocket, (struct sockaddr*)&addr, &length)) < 0) {
    perror("ASSERT - Error on accept().");
    exit(1);
  }
  
  return fd;
}
