#!/usr/bin/perl -w
# SEP Obfuscation function
# Jerome Nokin - February 2013 - http://funoverip.net

package SEPM::SEPM;

sub __ROL__ {
    my $number =  shift;
    my $bits2rotate = shift;
    for (1..$bits2rotate) {
        my $high_bit = ($number & 0b10000000000000000000000000000000) >> 31;
        $number = ($number << 1) & 0xffffffff;
        if ($high_bit){
                $number |= 0b00000000000000000000000000000001;
        }
    }
    return $number;
}

sub __ROR__ {
    my $number = shift;
    my $bits2rotate = shift;
    for (1..$bits2rotate) {
        my $low_bit = $number & 0b00000000000000000000000000000001;
        $number = ($number >> 1) & 0xffffffff;
        if ($low_bit) {
            $number |= 0b10000000000000000000000000000000;
        }
    }
    return $number;
}


sub BYTE0 {
        my $num = shift;
        return $num  & 0x000000ff;
}
sub BYTE1 {
        my $num = shift;
        return ($num >> 8)  & 0x000000ff;
}
sub BYTE2 {
        my $num = shift;
        return ($num >> 16)  & 0x000000ff;
}
sub BYTE3 {
        my $num = shift;
        return ($num >> 24)  & 0x000000ff;
}



1;
