#! /usr/bin/python
"""
Module to parse appcheck database into python classes
"""
__author__="Gary O'leary-Steele"

#import sys
import re
from lxml import etree

class AppcheckDB:
    def __init__(self,db_file=""):
        self.checks = []
        if db_file:
            self.parse_appcheckdb(db_file)

    def __add__(self,db):
        self.checks.extend(db.checks)
        return self

    def parse_appcheckdb(self,xmlfile):
        try:
            appcheck_xml = etree.parse(xmlfile)
        except Exception as err:
            print "[i] Malformed Fuzz File:%s" % xmlfile
            print "Error",err
            return None
        for check in appcheck_xml.getroot():
            signature = CheckSig()
            if check.tag == "check":
                signature.title = check.find("title").text
                signature.group = check.find("group").text

            # Load signatures
            signatures = (check.findall("injection"))
            for sig in signatures:
                signature.add_signature({"id": sig.get("id","0"),
                                        "fuzz_type":sig.get("fuzz_type","pattern_match"),
                                        "fuzz_string": sig.get("string",""),
                                        "fuzz_string1": sig.get("string1",""), # Used for Blind Checks
                                        "fuzz_string2": sig.get("string2",""), # Used for Blind Checks
                                        "match_pattern": sig.get("grep",""),
                                        "look_in": sig.get("look_in","mainbody|mainheaders|redirectbody|redirectheaders"),
                                        "match_type": sig.get("greptype","regex"),
                                        "injected_time_delay": sig.get("injected_time_delay","10"),
                                        "weight": sig.get("weight","10"),
                                        "impact": sig.get("impact","1"),
                                        "append_or_replace": sig.get("AR","A"),
                                        "short_fuzz_description": sig.get("fuzz_desc","N/A")})
            
            signature.short_description = check.find("shortdescription").text
            signature.description = check.find("description").text
            self.checks.append(signature)
            
        return self.checks



class CheckSig:
    """
    Class used to build each individual signature group
    """
    def __init__(self,*args,**kargs):
        # Set defaults
        self.title = ""
        self.group = 0
        self.signatures = []
        self.short_description = "N/A"
        self.description = "N/A"

    def add_signature(self,sig):
        self.signatures.append(sig)





if __name__ == "__main__":
    #x = blindSQLpagelenDB()
    #for c in x.checks:
    #    for s in c.signatures:
    #        print s
        

    x = AppcheckDB("../vulns2.0.xml")
    for check in x.checks:
        print check.title
        for sig in check.signatures:
            print sig["match_pattern"]
    exit()
