# To change this template, choose Tools | Templates
# and open the template in the editor.

__author__="garyoleary"
__date__ ="$12-May-2011 14:41:52$"



class htmlVulnReport():
    def __init__(self,vulns,filename="report.html"):

        self.tables =[]
        self.html = """
<style type="text/css">
          #page {
            width:95%;
            margin-left: auto;
            margin-right: auto;
            margin-bottom: 5px;
            padding: 16px;
            text-align: left;
            clear: both;
            word-wrap: break-word;


          }

          /* roScripts

          ----------------------------------------------- */

          table {
          		border-collapse:collapse;
          		background:#EFF4FC repeat-x;
          		border-left:1px solid #686868;
          		border-right:1px solid #686868;
          		font:0.8em/145% 'Trebuchet MS',helvetica,arial,verdana;
          		color: #333;
          }

          td, th {
          		padding:5px;
          }

          caption {
          		padding: 0 0 .5em 0;
          		text-align: left;
          		font-size: 1.4em;
          		font-weight: bold;
          		/*text-transform: uppercase;*/
          		color: #333;
          		background: transparent;
          }

          /* =links
          ----------------------------------------------- */

          table a {
          		color:#950000;
          		text-decoration:none;
          }

          table a:link {}

          table a:visited {
          		font-weight:normal;
          		color:#666;
          		text-decoration: line-through;
          }

          table a:hover {
          		border-bottom: 1px dashed #bbb;
          }

          /* =head =foot
          ----------------------------------------------- */

          thead th, tfoot th, tfoot td {
          		background:#333 url(llsh.gif) repeat-x;
          		color:#fff
          }


         subthead th, tfoot th, tfoot td {
          		background:#777;
          		color:#333
                font-weight: bold;
          }


          tfoot td {
          		text-align:right
          }

          /* =body
          ----------------------------------------------- */

          tbody th, tbody td {
          		border-bottom: dotted 1px #333;
          }

          tbody th {
          		white-space: nowrap;
          }

          tbody th a {
          		color:#333;
          }

          .odd {}

          tbody tr:hover {
          		background:#fafafa
          }


          </style>


"""
        self.insert_tables(vulns)
        self.writeReport(filename)

    def insert_tables(self,vulns):
        tables = innerTables(vulns)
        for table in tables.get_tables():
            self.html = self.html + table


    def writeReport(self,filename):
        f = open(filename,"w")
        f.write("<html>")
        f.write(self.html)
        f.write("</html>")
        f.close()


class innerTables():
    def __init__(self,vulns):
        self.tables = []
        for vuln in vulns.vulns:

            if vuln.impact =="3":
                impact = "<font color = \"red\">HIGH</font>"
            elif vuln.impact =="2":
                impact = "<font color = \"orange\">Medium</font>"
            elif vuln.impact =="1":
                impact =  "<font color = \"blue\">Low</font>"

            htmltable = "<table width=\"80%\">"
            htmltable = htmltable + "<thead><tr><th colspan=2 scope=\"col\" align=\"left\" valign =\"top\">{0}</th></thead>\n".format(vuln.title)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Impact</td><td width='80%'>{0}</td></tr>\n".format(impact)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Description</td><td width='80%'>{0}</td></tr>\n".format(vuln.description)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Vulnerable Resource</td><td width='80%'>{0}</td></tr>\n".format(vuln.path)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Fuzzer Notes</td><td width='80%'>{0}</td></tr>\n".format(vuln.fuzz_notes)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Fuzz Case Description</td><td width='80%'>{0}</td></tr>\n".format(vuln.short_fuzz_description)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Weight</td><td width='80%'>{0}</td></tr>\n".format(vuln.weight)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Affected Paramater</td><td width='80%'>{0}</td></tr>\n".format(vuln.fuzzed_param)
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Multi-stage Notes:</td><td width='80%'>{0}</td></tr>\n".format(vuln.multistage_notes.replace("\n","<br/>"))
            htmltable = htmltable + "<tr valign='top'><td width='20%'>Fuzz String(s)</td><td width='80%'>{0}</td></tr>\n".format(vuln.fuzz_string)
            htmltable = htmltable + "</table><br/><br/>"
            
            self.tables.append(htmltable)

    def get_tables(self):
        return self.tables
    
    