// ExploitDotNetDCOM is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// ExploitDotNetDCOM is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with ExploitDotNetDCOM.  If not, see <http://www.gnu.org/licenses/>.

#include "stdafx.h"
#include "COMSupport.h"
#include <vcclr.h>

using namespace System;
using namespace System::Runtime::InteropServices;

// {AB894772-D1DC-4F02-BCE6-248A57AD087D}
static const GUID CLSID_ComServer =
{ 0xab894772, 0xd1dc, 0x4f02, { 0xbc, 0xe6, 0x24, 0x8a, 0x57, 0xad, 0x8, 0x7d } };

static const GUID CLSID_DFSVC = 
// 20FD4E26-8E0F-4F73-A0E0-F2 7B 8C 57 BE 6F
{ 0x20FD4E26, 0x8E0F, 0x4F73, { 0xA0, 0xE0, 0xF2, 0x7B, 0x8C, 0x57, 0xbE, 0x6F } };

Object^ WrapComObject(void* pUnk)
{
	IntPtr p(pUnk);

	return Marshal::GetObjectForIUnknown(p);
}

void ThrowHresult(HRESULT hr)
{
	if (FAILED(hr))
	{
		Marshal::ThrowExceptionForHR((int)hr);
	}
}

Object^ GetComObject(const GUID& clsid)
{
	IUnknown* pUnk;

	ThrowHresult(CoCreateInstance(clsid, nullptr, CLSCTX_LOCAL_SERVER, IID_PPV_ARGS(&pUnk)));

	return WrapComObject(pUnk);
}

Object^ GetComObject(Guid clsid)
{
	GUID* g = reinterpret_cast<GUID*>(&clsid);

	return GetComObject(*g);
}

Object^ GetComObjectFromObjRef(String^ objref)
{
	IBindCtx* pBindCtx = nullptr;
	IMoniker* pMoniker = nullptr;
	ULONG cchEaten = 0;

	pin_ptr<const wchar_t> displayName = PtrToStringChars(objref);

	ThrowHresult(CreateBindCtx(0, &pBindCtx));
	ThrowHresult(MkParseDisplayName(pBindCtx, displayName, &cchEaten, &pMoniker));

	void* pUnk;

	ThrowHresult(pMoniker->BindToObject(pBindCtx, nullptr, IID_IUnknown, &pUnk));

	pMoniker->Release();
	pBindCtx->Release();

	return WrapComObject(pUnk);
}

IUnknownPtr GetInterfaceForObject(Object^ obj)
{
	IntPtr p = Marshal::GetIUnknownForObject(obj);
	IUnknownPtr ret;

	ret.Attach(reinterpret_cast<IUnknown*>(p.ToPointer()));

	return ret;
}

bool RunCOMEquals(Object^ targetObj, Object^ equalsObj)
{
	mscorlib::_ObjectPtr target = GetInterfaceForObject(targetObj);
	IUnknownPtr obj = GetInterfaceForObject(equalsObj);

	return target->Equals(obj.GetInterfacePtr()) == VARIANT_TRUE;
}

array<unsigned char>^ GetArrayFromBuffer(unsigned char* buf, int length)
{
	array<unsigned char>^ ret = gcnew array<unsigned char>(length);

	Marshal::Copy(IntPtr(buf), ret, 0, length);

	return ret;
}

array<unsigned char>^ MarshalObject(IUnknown* pUnk)
{
	IMoniker* pMoniker;
	HRESULT hr = CreateObjrefMoniker(pUnk, &pMoniker);
	array<unsigned char>^ ret = nullptr;

	if (SUCCEEDED(hr))
	{				
		LPOLESTR lpDisplayName;

		hr = pMoniker->GetDisplayName(nullptr, nullptr, &lpDisplayName);

		pMoniker->Release();

		if (FAILED(hr))
		{
			Marshal::ThrowExceptionForHR((int)hr);
		}

		String^ displayName = gcnew String(lpDisplayName);
		CoTaskMemFree(lpDisplayName);

		ret = Convert::FromBase64String(displayName->Substring(7, displayName->Length - 8));
	}
	else
	{
		Marshal::ThrowExceptionForHR((int)hr);		
	}

	return ret;
}

bool IsObject(VARIANT& v)
{
	return v.vt == VT_UNKNOWN || v.vt == VT_DISPATCH;
}

variant_t ConvertObjectToVariant(Object^ obj)
{	
	variant_t ret;

	Marshal::GetNativeVariantForObject(obj, IntPtr(&ret));

	return ret;
}

HRESULT InvokeDispatch(IDispatchPtr pDisp, bstr_t name, std::vector<variant_t>& args, variant_t& vret)
{
	HRESULT hr = E_FAIL;
	LPOLESTR names[1];
	DISPID dispid;

	names[0] = name.GetBSTR();	

	hr = pDisp->GetIDsOfNames(IID_NULL, names, 1, LOCALE_SYSTEM_DEFAULT, &dispid);

	if (SUCCEEDED(hr))
	{
		::DISPPARAMS dp;		

		dp.cArgs = args.size();
		dp.cNamedArgs = 0;
		dp.rgdispidNamedArgs = nullptr;

		if (args.size() > 0)
		{
			dp.rgvarg = &args[0];
		}
		else
		{
			dp.rgvarg = nullptr;
		}

		hr = pDisp->Invoke(dispid, IID_NULL, LOCALE_SYSTEM_DEFAULT, DISPATCH_METHOD, &dp, &vret, nullptr, nullptr);
	}

	return hr;
}

HRESULT GetPropertyDispatch(IDispatchPtr pDisp, bstr_t name, std::vector<variant_t>& args, variant_t& vret)
{
	HRESULT hr = E_FAIL;
	LPOLESTR names[1];
	DISPID dispid;

	names[0] = name.GetBSTR();

	hr = pDisp->GetIDsOfNames(IID_NULL, names, 1, LOCALE_SYSTEM_DEFAULT, &dispid);

	if (SUCCEEDED(hr))
	{
		::DISPPARAMS dp;

		dp.cArgs = args.size();
		dp.cNamedArgs = 0;
		dp.rgdispidNamedArgs = nullptr;

		if (args.size() > 0)
		{
			dp.rgvarg = &args[0];
		}
		else
		{
			dp.rgvarg = nullptr;
		}

		hr = pDisp->Invoke(dispid, IID_NULL, LOCALE_SYSTEM_DEFAULT, DISPATCH_PROPERTYGET, &dp, &vret, nullptr, nullptr);
	}

	return hr;
}

SAFEARRAY* GetArguments(std::vector<variant_t>& args)
{	
	SAFEARRAY * psa;
	SAFEARRAYBOUND rgsabound[1];

	rgsabound[0].lLbound = 0;
	rgsabound[0].cElements = (ULONG)args.size();
	psa = SafeArrayCreate(VT_VARIANT, 1, rgsabound);

	for (LONG indicies = 0; indicies < (LONG)args.size(); ++indicies)
	{
		SafeArrayPutElement(psa, &indicies, &args[indicies]);
	}

	return psa;
}

String^ VariantAsString(variant_t v)
{
	v.ChangeType(VT_BSTR);

	return gcnew String(v.bstrVal);
}