#ifndef __VM86UTIL_H

#define SYM(s) STR(s)
#define STR(s) #s

typedef enum {
    Vm86PlusInstallCheck,
    Vm86Enter,
    Vm86EnterNoBypass,
    Vm86RequestIrq,
    Vm86FreeIrq,
    Vm86GetIrqBits,
    Vm86GetAndResetIrq,
} vm86func_t;

typedef struct vm86_regs vm86regs_t;
typedef struct vm86plus_struct vm86_t;

// Calculate a linear address from CS:IP pair
#define REAL(cs,ip) ((void *)(((cs) << 4) + ((ip) & 0xffff)))

#define EFLAGS_CF_MASK   0x00000001 // carry flag
#define EFLAGS_PF_MASK   0x00000004 // parity flag
#define EFLAGS_AF_MASK   0x00000010 // auxiliary carry flag
#define EFLAGS_ZF_MASK   0x00000040 // zero flag
#define EFLAGS_SF_MASK   0x00000080 // sign flag
#define EFLAGS_TF_MASK   0x00000100 // trap flag
#define EFLAGS_IF_MASK   0x00000200 // interrupt flag
#define EFLAGS_DF_MASK   0x00000400 // direction flag
#define EFLAGS_OF_MASK   0x00000800 // overflow flag
#define EFLAGS_IOPL_MASK 0x00003000 // I/O privilege level
#define EFLAGS_NT_MASK   0x00004000 // nested task
#define EFLAGS_RF_MASK   0x00010000 // resume flag
#define EFLAGS_VM_MASK   0x00020000 // virtual 8086 mode
#define EFLAGS_AC_MASK   0x00040000 // alignment check
#define EFLAGS_VIF_MASK  0x00080000 // virtual interrupt flag
#define EFLAGS_VIP_MASK  0x00100000 // virtual interrupt pending
#define EFLAGS_ID_MASK   0x00200000 // identification flag

#ifdef __OPTIMIZE__
# error The CODE16() and CODE32() macros might be eliminated as dead code with optimization enabled.
#endif

// Generate 16bit code inline
#define CODE16(code, label, size) do { \
        __label__ c16start, c16end; \
        volatile uint8_t *end = &&c16end; \
        goto *end; c16start: \
        asm volatile (".intel_syntax noprefix\n" \
                      ".code16\n" \
                      code "\n" \
                      ".code32\n" \
                      ".att_syntax prefix\n"); \
        c16end: \
        (label) = &&c16start; \
        (size) = end - (label); \
    } while (false)

// Generate 32bit code inline
#define CODE32(code, label, size) do { \
        __label__ c32start, c32end; \
        volatile uint8_t *end = &&c32end; \
        goto *end; c32start: \
        asm volatile (".intel_syntax noprefix\n" \
                      code "\n" \
                      ".att_syntax prefix\n"); \
        c32end: \
        (label) = &&c32start; \
        (size) = end - (label); \
    } while (false)

#define __VM86UTIL_H
#else
# warning vm86util.h included twice
#endif
