/*
 * DO NOT DISTRIBUTE -*- PRIVATE DISTRIBUTION -*-
 * 
 * HSMP Client

 * Communicates with Hybrid Networks' Cable Modem.  This is
 * an unauthenticated management protocol that operates over UDP.
 *
 *
 * By David Goldsmith
 * <dhg@ksrt.org>
 *
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>

#include "hybrid_cable.h"

#define COMMAND_SZ (sizeof(buff) - sizeof(struct hybrid_pkt_hdr))
#define RECVBUFF_SZ 4096
#define HSMP_PORT 7777

void
initialize_hybrid_packet( char *buff )
{
   struct hybrid_pkt_hdr *pkt_p;

   pkt_p = (struct hybrid_pkt *)buff;

   pkt_p->header = 0x00;
   pkt_p->trans_id = htons(0x0105);
   pkt_p->unknown = 0x00000000;
   pkt_p->unknown2 = htonl(0x00000001); 
   pkt_p->unknown3 = htonl(0xffffffff);
   pkt_p->pad = 0x00;
   pkt_p->unknown_byte1 = 0x0f;
   pkt_p->unknown_byte2 = 0x0a;
   pkt_p->pad2 = 0x00;
   pkt_p->cmd_sz = 0;
   pkt_p->pad3 = 0x00000000;
}

void
insert_command( char *packet, char *command )
{
   struct hybrid_pkt *hy_pkt;

   hy_pkt = (struct hybrid_pkt *)packet;

   memset( &hy_pkt->command, 0x0, strlen(command + 1) );
   strcpy( &hy_pkt->command, command );
   hy_pkt->p_hdr.cmd_sz = strlen( command );
}

int
write_packet( int fd, char *packet )
{
   int packet_sz, ret;
   struct hybrid_pkt_hdr *pkt;

   pkt = (struct hybrid_pkt_hdr *)packet;

   /* +1 for NULL byte */
   packet_sz = sizeof(struct hybrid_pkt_hdr) + pkt->cmd_sz + 1; 
   ret = send( fd, packet, packet_sz, 0 );
   
   return( ret );
}

int
read_packet( int fd, char *buff )
{
   return( recv( fd, buff, RECVBUFF_SZ, 0 ) );
}

struct hostent *
fill_host( machine, host )
char *machine;
struct hostent *host;
{
   /* if gethostbyname fails, gethostbyaddr and return */

  if ( ( host = gethostbyname( machine ) ) == NULL )
     host = gethostbyaddr( machine, 4, AF_INET );
  return( host );
}

main(int argc, char **argv) 
{
   struct hybrid_pkt *pkt;
   static char buff[500], recv_buff[RECVBUFF_SZ];
   char user_input[COMMAND_SZ];
   struct hostent *host;
   struct sockaddr_in hyb_sai;
   int sai_sz;
   int hyb_sock;
   int ret, quit;

   quit = 0;

   if ( argc != 2 )
   {
      printf("hsmp <hostname|ip-address>\n");
      exit(-1);
   }
   /* fill our hostent structure given argv[1] */

   if ( ( host = fill_host( argv[1], host ) ) == NULL )
     exit(-1);

   /* fill our sockaddr_in structure */

   sai_sz = sizeof( struct sockaddr_in );
   hyb_sai.sin_family = host->h_addrtype;
   hyb_sai.sin_addr.s_addr = *((long *)host->h_addr);
   hyb_sai.sin_port = htons( HSMP_PORT );
   
   hyb_sock = socket( PF_INET, SOCK_DGRAM, IPPROTO_UDP );
   if ( hyb_sock != -1 )
   {
      ret = connect( hyb_sock, (struct sockaddr *)&hyb_sai, sai_sz ); 
      if ( ret != -1 )
      {
         initialize_hybrid_packet( buff );

         while ( quit == 0 )
         {
            memset( recv_buff, 0x0, RECVBUFF_SZ );
            printf("> ");
            fgets( user_input, COMMAND_SZ, stdin );
            if ( strcmp( user_input, "quit\n" ) == 0 )
               quit++;
            else
            {
               user_input[strlen(user_input) - 1] = '\0';
               insert_command( buff, user_input );
               write_packet( hyb_sock, buff );
               read_packet( hyb_sock, recv_buff );
               printf("%s\n", recv_buff+16 );
            }
         }
      }
   }
}
