import java.lang.*;
import java.io.*;
import java.util.*;
import java.text.*;

public class FileHelper {

 public InputStream getInput(String s) {
  FileInputStream f=null;
  try {
   f=new FileInputStream(s);
  } catch(Throwable e) {}
  return (InputStream)f;
 }

 public OutputStream getOutput(String s) {
  FileOutputStream f=null;
  try {
   f=new FileOutputStream(s);
  } catch(Throwable e) {}
  return (OutputStream)f;
 }

 void printFileInfo(PrintWriter out,String name) {
  String months[]={"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  DateFormat df;
  String s="";
  long i,j;

  File f=new File(name);

  if (f.isDirectory()) s+='d';
   else s+='-';

  if (f.canRead()) s+='r';
   else s+='-';

  if (f.canWrite())s+='w';
   else s+='-';

  s+="-------   ";
  out.write(s);

  if (f.isDirectory()) {
   i=3;j=0;
  } else {
   i=1;
   j=f.length();
  }

  out.write(String.valueOf(i)+" owner group ");

  s="            ";
  String len=String.valueOf(j);
  if(len.length()<s.length()) 
   len=s.substring(0,s.length()-len.length())+len;
  out.write(len+" ");

  Date date=new Date(f.lastModified());
  Calendar cal=new GregorianCalendar();
  cal.setTime(date);
  String s1=months[cal.get(Calendar.MONTH)]+' ';
  String s2=String.valueOf(cal.get(Calendar.DATE));
  if (s2.length()==1) s2=' '+s2;
  s1+=s2+' ';
  if (Math.abs(System.currentTimeMillis()-date.getTime())>183L*24L*60L*60L*1000L) 
   df=new SimpleDateFormat(" yyyy");
  else df=new SimpleDateFormat("HH:mm");
  s=s1+df.format(date);

  out.write(s+" ");
  out.println(f.getName());
 }

 public void list(String dir,PrintWriter out) {
  int i;
  File f=new File(dir);
  String list[]=f.list();
  if (list!=null)     
   for(i=0;i<list.length;i++) {
    printFileInfo(out,dir+File.separator+list[i]); 
   } 
 }

 public void delete(String s) {
  try {
   int i;
   File f=new File(s);
   if (f.isDirectory()) {
    String list[]=f.list();
    if (list!=null)     
     for(i=0;i<list.length;i++) {
      delete(s+File.separator+list[i]); 
     }
   } 
   f.delete();
  } catch(Throwable e) {}
 }

 public void mkdir(String s) {
  try {
   File f=new File(s);
   f.mkdir();
  } catch(Throwable e) {}
 }

 public Boolean exists(String s) {
  File f=new File(s);
  return new Boolean(f.exists());
 }

 public void rename(String from,String to) {
  File f1=new File(from);
  File f2=new File(to);
  f1.renameTo(f2);
 }

}

