#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <fcntl.h>

#define		FTP_PORT	21


unsigned long net_resolve_host(char *hostname)
{
	unsigned long	addr;
	struct hostent	*host;

	host = gethostbyname(hostname);
	if (host == NULL)
	{
		addr = inet_addr(hostname);
		if (addr < 0)
		{
			perror("error while resolving hostname");
			exit(-1);
		}
		return (addr);
	}
	
	return (*(unsigned long *)host->h_addr);
}

int net_set_nonblock(int sock)
{
	int	x;
	int	flags;

	flags = fcntl(sock, F_GETFL, 0);
	if (flags == 1)
	{
		close(sock);
		exit (-1);
	}
	x = fcntl(sock, F_SETFL, flags | O_NONBLOCK);
	if (x == -1)
	{
		close(sock);
		exit (-1);
	}

	return (1);
}

int net_connect(char *hostname)
{
	int			sock;
	struct sockaddr_in	addr;
	int			x;	

	addr.sin_family = AF_INET;
	addr.sin_port = htons(FTP_PORT);
	addr.sin_addr.s_addr = net_resolve_host(hostname);
	
	sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (sock < 0)
	{
		perror("error while getting the socket");
		exit(-1);
	}
	
	x = connect(sock, (struct sockaddr *)&addr, sizeof(addr));
	if (x < 0)
	{
		perror("error while connecting");
		exit(-1);
	}

	return (sock);
}	

int net_send(int sock, char *sendbuf, int len)
{
	int	x;

	if ((x = send(sock, sendbuf, len, 0)) < 0)
	{
		perror("error while sending data.");
		exit(-1);
	}

	return (x);
}

int net_recv(int sock, char *recvbuf, int len)
{
	int 	x;

	if (recvbuf == NULL)
	{
		perror("error while receiving data.");
		exit(-1);
	}

	memset(recvbuf, '\0', len);
	if ((x = recv(sock, recvbuf, len - 1, 0)) < 0)
	{
		perror("error while receiving data.");
		exit(-1);
	}

	recvbuf[x] = '\0';

	return x;
}

int net_recv_until(int sock, char *recvbuf, int len, char *string)
{
	int	x;

	if (recvbuf == NULL)
	{
		perror("error while receiving data.");
		exit(-1);
	}
	
	do
	{
		memset(recvbuf, '\0', len);
		x = net_recv(sock, recvbuf, len);
	} while (strstr(recvbuf, string) == NULL);

	return x;
}

int net_ftp_login(int sock, char *user, char *pass)
{
	char	userbuf[2048];
	char	passbuf[2048];
	char	recvbuf[1024];

	memset(userbuf, '\0', sizeof(userbuf));
	memset(passbuf, '\0', sizeof(passbuf));
	memset(recvbuf, '\0', sizeof(recvbuf));

	net_recv_until(sock, recvbuf, sizeof(recvbuf), "220 ");

	snprintf(userbuf, sizeof(userbuf), "USER %s\r\n", user);
	snprintf(passbuf, sizeof(passbuf), "PASS %s\r\n", pass);

	net_send(sock, userbuf, strlen(userbuf));	
	net_recv_until(sock, recvbuf, sizeof(recvbuf), "331 ");
	
	memset(recvbuf, '\0', sizeof(recvbuf));
	net_send(sock, passbuf, strlen(passbuf));	
	net_recv_until(sock, recvbuf, sizeof(recvbuf), "230 ");

	return 1;
}
	









