/*

VERSION 0.1.1

Half-Life packets decoding function
by Luigi Auriemma
e-mail: aluigi@pivx.com
web:    http://aluigi.altervista.org


How to use:

mybuff = buffer that contains the packet's data
bufflen = size of the data

hldec(mybuff, bufflen);


Now mybuff contains the decoded buffer 8-)



This software is covered by GNU/GPL
*/



#define HLDECHASH    "\x05\x61\x7A\xED\x1B\xCA\x0D\x9B\x4A\xF1\x64\xC7\xB5\x8E\xDF\xA0"



void hldec(unsigned char *buff, unsigned long pcksz);
unsigned long hldec2(unsigned long ecx);




void hldec(unsigned char *buff, unsigned long pcksz) {
    unsigned char    ebpc[4],
            tmpbyte,
            *ptresi;
    unsigned long    ecx,
            edx,
            pcknum,
            invnum,
            cont = 0,
            i;

    if(pcksz < 9) return;
    pcknum = *buff;
    invnum = ~pcknum;
    pcksz = (pcksz - 8) >> 2;
    buff += 8;

    for(i = 0; i < pcksz; i++) {
        *(unsigned long *)ebpc = *(unsigned long *)buff ^ pcknum;

        ptresi = ebpc;
        for(ecx = 0; ecx < 4; ecx++) {
            tmpbyte = ecx << ecx;
            edx = *(HLDECHASH + ((cont + ecx) & 0xf));
            edx |= tmpbyte;
            edx |= ecx;
            edx |= 0xA5;
            *ptresi ^= edx;
            ptresi++;
        }

        *(unsigned long *)buff = hldec2(*(unsigned long *)ebpc);
        *(unsigned long *)buff ^= invnum;
        buff += 4;
        cont++;
    }
}





unsigned long hldec2(unsigned long ecx) {
    ecx = ((((ecx) & 0xff000000) >> 24) |
          (((ecx) & 0x00ff0000) >>  8) |
          (((ecx) & 0x0000ff00) <<  8) |
          (((ecx) & 0x000000ff) << 24));
    return(ecx);
}


