/*
 * Decompiled with CFR 0.152.
 */
package burp.faraday;

import burp.IExtensionHelpers;
import burp.IHttpRequestResponse;
import burp.IHttpService;
import burp.IParameter;
import burp.IRequestInfo;
import burp.IScanIssue;
import burp.faraday.models.vulnerability.Host;
import burp.faraday.models.vulnerability.Service;
import burp.faraday.models.vulnerability.Vulnerability;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public class VulnerabilityMapper {
    private static IExtensionHelpers helpers;

    public static void setHelpers(IExtensionHelpers helpers) {
        VulnerabilityMapper.helpers = helpers;
    }

    public static Vulnerability fromIssue(IScanIssue issue) {
        Host host = VulnerabilityMapper.getHostFromIssue(issue);
        Service service = VulnerabilityMapper.getServiceFromIssue(issue);
        Vulnerability vulnerability = VulnerabilityMapper.getVulnerabilityFromIssue(issue);
        vulnerability.setHost(host);
        vulnerability.setService(service);
        return vulnerability;
    }

    public static Vulnerability fromRequest(IHttpRequestResponse message) {
        Host host = VulnerabilityMapper.getHostFromMessage(message);
        Service service = VulnerabilityMapper.getServiceFromMessage(message);
        Vulnerability vulnerability = VulnerabilityMapper.getVulnerabilityFromMessage(message);
        vulnerability.setHost(host);
        vulnerability.setService(service);
        return vulnerability;
    }

    private static Host getHostFromIssue(IScanIssue issue) {
        Host host = new Host();
        String hostname = issue.getUrl().getHost();
        VulnerabilityMapper.setHostnameAndIP(host, hostname, issue.getHttpService());
        return host;
    }

    private static Host getHostFromMessage(IHttpRequestResponse message) {
        Host host = new Host();
        String hostname = message.getHttpService().getHost();
        VulnerabilityMapper.setHostnameAndIP(host, hostname, message.getHttpService());
        return host;
    }

    private static Service getServiceFromIssue(IScanIssue issue) {
        Service service = new Service();
        service.setName(issue.getHttpService().getProtocol());
        service.setProtocol(issue.getUrl().getProtocol());
        service.setPorts(new int[]{issue.getUrl().getPort()});
        service.setStatus("open");
        return service;
    }

    private static Service getServiceFromMessage(IHttpRequestResponse message) {
        Service service = new Service();
        IHttpService httpService = message.getHttpService();
        service.setName(httpService.getProtocol());
        service.setProtocol(httpService.getProtocol());
        service.setPorts(new int[]{httpService.getPort()});
        service.setStatus("open");
        return service;
    }

    private static Vulnerability getVulnerabilityFromIssue(IScanIssue issue) {
        Vulnerability vulnerability = new Vulnerability();
        vulnerability.setName(issue.getIssueName());
        vulnerability.setSeverity(VulnerabilityMapper.parseSeverity(issue));
        vulnerability.setResolution(VulnerabilityMapper.parseResolution(issue));
        vulnerability.setDescription(VulnerabilityMapper.parseDescription(issue));
        vulnerability.setPath(issue.getUrl().getPath());
        vulnerability.setWebsite(issue.getUrl().toString());
        if (issue.getHttpMessages().length > 0) {
            vulnerability.setType("VulnerabilityWeb");
            IHttpRequestResponse message = issue.getHttpMessages()[0];
            IRequestInfo requestInfo = helpers.analyzeRequest(message);
            VulnerabilityMapper.addMessageToVuln(vulnerability, message, requestInfo);
        }
        return vulnerability;
    }

    private static String parseSeverity(IScanIssue issue) {
        if (issue.getSeverity().equals("False positive")) {
            return "unclassified";
        }
        if (issue.getSeverity().equals("Information")) {
            return "informational";
        }
        return issue.getSeverity().toLowerCase();
    }

    private static String parseDescription(IScanIssue issue) {
        String background;
        StringBuilder description = new StringBuilder();
        if (issue.getIssueDetail() != null && !issue.getIssueDetail().isEmpty()) {
            description.append("Detail\n");
            description.append(issue.getIssueDetail());
        }
        if ((background = issue.getIssueBackground()) != null && !background.isEmpty()) {
            description.append("Background\n");
            description.append(background);
        }
        return description.toString().replaceAll("<(/p|br/|/li|/ul|/ol)>", "\n").replaceAll("<li>", "* ").replaceAll("</?[^>]*>", "");
    }

    private static String parseParameters(List<IParameter> parameterList) {
        StringBuilder params = new StringBuilder();
        for (IParameter p : parameterList) {
            params.append(p.getType());
            params.append(":");
            params.append(p.getName());
            params.append("=");
            params.append(p.getValue());
            params.append(",");
        }
        return params.toString();
    }

    private static String parseResolution(IScanIssue issue) {
        String remediation = issue.getRemediationBackground();
        if (remediation == null) {
            return "";
        }
        return remediation.replaceAll("<(/p|br/|/li)>", "\n").replaceAll("<li>", "* ").replaceAll("</?[^>]*>", "");
    }

    private static Vulnerability getVulnerabilityFromMessage(IHttpRequestResponse message) {
        Vulnerability vulnerability = new Vulnerability();
        IRequestInfo requestInfo = helpers.analyzeRequest(message);
        vulnerability.setName("Analyzing: (" + requestInfo.getUrl().getPath().substring(0, 20) + ")");
        vulnerability.setSeverity("informational");
        vulnerability.setDescription("This request was manually sent using the Faraday for Burp extension.");
        vulnerability.setPath(requestInfo.getUrl().getPath());
        vulnerability.setWebsite(requestInfo.getUrl().toString());
        vulnerability.setType("VulnerabilityWeb");
        VulnerabilityMapper.addMessageToVuln(vulnerability, message, requestInfo);
        return vulnerability;
    }

    private static void addMessageToVuln(Vulnerability vulnerability, IHttpRequestResponse message, IRequestInfo requestInfo) {
        String query = requestInfo.getUrl().getQuery() != null ? requestInfo.getUrl().getQuery() : "";
        byte[] request = message.getRequest();
        byte[] response = message.getResponse();
        if (VulnerabilityMapper.containsNullByte(request)) {
            vulnerability.setRequest("Binary request encoded with Base64:\n\n" + helpers.base64Encode(request));
        } else {
            vulnerability.setRequest(new String(request));
        }
        if (VulnerabilityMapper.containsNullByte(response)) {
            vulnerability.setResponse("Binary response encoded with Base64:\n\n" + helpers.base64Encode(response));
        } else {
            vulnerability.setResponse(new String(response));
        }
        vulnerability.setMethod(requestInfo.getMethod());
        vulnerability.setParams(VulnerabilityMapper.parseParameters(requestInfo.getParameters()));
        vulnerability.setQuery(query);
    }

    private static void setHostnameAndIP(Host host, String hostname, IHttpService service) {
        host.setHostnames(new String[]{hostname});
        String ip = hostname;
        try {
            ip = InetAddress.getByName(service.getHost()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        host.setIp(ip);
    }

    private static boolean containsNullByte(byte[] byteArray) {
        for (byte b : byteArray) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }
}

